/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.core.io.Resource;
import org.springframework.ide.eclipse.beans.core.BeanDefinitionException;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanProperty;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.internal.parser.EventBeanDefinitionRegistry;
import org.springframework.ide.eclipse.beans.core.internal.parser.IBeanDefinitionEvents;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.io.FileResource;
import org.springframework.ide.eclipse.core.io.xml.LineNumberPreservingDOMParser;
import org.springframework.ide.eclipse.core.model.AbstractSourceModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BeansConfig
extends AbstractSourceModelElement
implements IBeansConfig {
    private IFile file;
    private List beans;
    private Map beansMap;
    private List innerBeans;
    private Map beanClassesMap;
    private BeanDefinitionException exception;

    public BeansConfig(IBeansProject project, String name) {
        super((IModelElement)project, name);
        this.file = this.getFile(name);
        if (this.file == null) {
            this.exception = new BeanDefinitionException("File not found");
        }
    }

    public int getElementType() {
        return 3;
    }

    public IModelElement[] getElementChildren() {
        return this.getBeans().toArray(new IModelElement[this.getBeans().size()]);
    }

    public IResource getElementResource() {
        return this.file;
    }

    public void accept(IModelElementVisitor visitor) {
        if (visitor.visit((IModelElement)this)) {
            Iterator iter = this.beans.iterator();
            while (iter.hasNext()) {
                IModelElement element = (IModelElement)iter.next();
                element.accept(visitor);
            }
        }
    }

    public void reset() {
        this.beans = null;
        this.beansMap = null;
        this.innerBeans = null;
        this.beanClassesMap = null;
        this.exception = null;
        IBeansProject project = (IBeansProject)this.getElementParent();
        Iterator configSets = project.getConfigSets().iterator();
        while (configSets.hasNext()) {
            BeansConfigSet configSet = (BeansConfigSet)configSets.next();
            if (!configSet.hasConfig(this.getElementName())) continue;
            configSet.reset();
        }
    }

    public boolean isReset() {
        return this.beans == null;
    }

    public IFile getConfigFile() {
        return this.file;
    }

    public String getConfigPath() {
        return this.file != null ? this.file.getFullPath().toString() : null;
    }

    public boolean hasBean(String name) {
        if (name != null) {
            return this.getBeansMap().containsKey(name);
        }
        return false;
    }

    public IBean getBean(String name) {
        if (name != null) {
            return (IBean)this.getBeansMap().get(name);
        }
        return null;
    }

    public Collection getBeans() {
        if (this.beans == null) {
            this.readConfig();
        }
        return this.beans;
    }

    public Collection getInnerBeans() {
        if (this.innerBeans == null) {
            this.readConfig();
        }
        return this.innerBeans;
    }

    public BeanDefinitionException getException() {
        if (this.beans == null) {
            this.readConfig();
        }
        return this.exception;
    }

    public boolean isBeanClass(String className) {
        if (className != null) {
            return this.getBeanClassesMap().containsKey(className);
        }
        return false;
    }

    public Collection getBeanClasses() {
        return this.getBeanClassesMap().keySet();
    }

    public Collection getBeans(String className) {
        if (this.isBeanClass(className)) {
            return (Collection)this.getBeanClassesMap().get(className);
        }
        return Collections.EMPTY_LIST;
    }

    public String toString() {
        return String.valueOf(this.getElementName()) + ": " + this.getBeans().toString();
    }

    private IFile getFile(String name) {
        Object container = name.charAt(0) == '/' ? ResourcesPlugin.getWorkspace().getRoot() : (IProject)((ISourceModelElement)this.getElementParent()).getElementResource();
        return (IFile)container.findMember(name);
    }

    private Map getBeansMap() {
        if (this.beansMap == null) {
            this.readConfig();
        }
        return this.beansMap;
    }

    private Map getBeanClassesMap() {
        if (this.beanClassesMap == null) {
            IBean bean;
            this.beanClassesMap = new HashMap();
            Iterator beans = this.getBeans().iterator();
            while (beans.hasNext()) {
                bean = (IBean)beans.next();
                this.addBeanClassToMap(bean);
            }
            beans = this.getInnerBeans().iterator();
            while (beans.hasNext()) {
                bean = (IBean)beans.next();
                this.addBeanClassToMap(bean);
            }
        }
        return this.beanClassesMap;
    }

    private void addBeanClassToMap(IBean bean) {
        String className = bean.getClassName();
        if (className != null) {
            ArrayList<IBean> beanClassBeans;
            int pos = className.indexOf(36);
            if (pos > 0) {
                className = className.substring(0, pos);
            }
            if ((beanClassBeans = (ArrayList<IBean>)this.beanClassesMap.get(className)) == null) {
                beanClassBeans = new ArrayList<IBean>();
                this.beanClassesMap.put(className, beanClassBeans);
            }
            beanClassBeans.add(bean);
        }
    }

    private void readConfig() {
        this.beans = new ArrayList();
        this.beansMap = new HashMap();
        this.innerBeans = new ArrayList();
        BeansConfigHandler handler = new BeansConfigHandler(this);
        EventBeanDefinitionRegistry registry = new EventBeanDefinitionRegistry(handler);
        try {
            registry.loadBeanDefinitions((Resource)new FileResource(this.file));
        }
        catch (BeanDefinitionException e) {
            this.exception = e;
        }
    }

    private final class BeansConfigHandler
    implements IBeanDefinitionEvents {
        private IBeansConfig config;
        private Stack nestedElements;
        private ISourceModelElement currentElement;
        private Stack nestedBeans;
        private Bean currentBean;

        public BeansConfigHandler(IBeansConfig config) {
            this.config = config;
            this.nestedElements = new Stack();
            this.nestedBeans = new Stack();
        }

        public void startBean(Element element, boolean isNestedBean) {
            if (isNestedBean) {
                this.nestedElements.push(this.currentElement);
                this.nestedBeans.push(this.currentBean);
            }
            this.currentBean = new Bean(this.config);
            this.setXmlTextRange(this.currentBean, element);
        }

        public void registerBean(BeanDefinitionHolder bdHolder, boolean isNestedBean) {
            this.currentBean.setBeanDefinitionHolder(bdHolder);
            if (isNestedBean) {
                this.currentElement = (ISourceModelElement)this.nestedElements.pop();
                this.currentBean.setElementParent((IModelElement)this.currentElement);
                BeansConfig.this.innerBeans.add(this.currentBean);
                Bean outerBean = this.currentElement instanceof BeanConstructorArgument ? (Bean)((IBeanConstructorArgument)this.currentElement).getElementParent() : (Bean)((IBeanProperty)this.currentElement).getElementParent();
                outerBean.addInnerBean(this.currentBean);
                this.currentBean = (Bean)this.nestedBeans.pop();
            } else {
                BeansConfig.this.beans.add(this.currentBean);
                BeansConfig.this.beansMap.put(bdHolder.getBeanName(), this.currentBean);
            }
        }

        public void startConstructorArgument(Element element) {
            BeanConstructorArgument carg = new BeanConstructorArgument(this.currentBean);
            this.setXmlTextRange(carg, element);
            this.currentBean.addConstructorArgument(carg);
            this.currentElement = carg;
        }

        public void registerConstructorArgument(int index, Object value, String type) {
            BeanConstructorArgument carg = (BeanConstructorArgument)this.currentElement;
            carg.setIndex(index);
            carg.setValue(value);
            carg.setType(type);
            StringBuffer name = new StringBuffer();
            if (index != -1) {
                name.append(index);
                name.append(':');
            }
            if (type != null) {
                name.append(type);
                name.append(':');
            }
            if (value != null) {
                name.append(value.toString());
            } else {
                name.append("NULL");
            }
            carg.setElementName(name.toString());
        }

        public void startProperty(Element element) {
            BeanProperty property = new BeanProperty(this.currentBean);
            this.setXmlTextRange(property, element);
            this.currentElement = property;
        }

        public void registerProperty(String name, PropertyValues pvs) {
            BeanProperty property = (BeanProperty)this.currentElement;
            property.setElementName(name);
            Object value = pvs.getPropertyValue(name).getValue();
            property.setValue(value);
            this.currentBean.addProperty(property);
        }

        private void setXmlTextRange(ISourceModelElement modelElement, Element xmlElement) {
            int startLine = LineNumberPreservingDOMParser.getStartLineNumber((Node)xmlElement);
            int endLine = LineNumberPreservingDOMParser.getEndLineNumber((Node)xmlElement);
            ((AbstractSourceModelElement)modelElement).setElementStartLine(startLine);
            ((AbstractSourceModelElement)modelElement).setElementEndLine(endLine);
        }
    }
}

