/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;

public class BeansModelImageDescriptor
extends CompositeImageDescriptor {
    public static final int FLAG_IS_EXTERNAL = 1;
    public static final int FLAG_HAS_ERRORS = 2;
    public static final int FLAG_HAS_WARNINGS = 4;
    public static final int FLAG_IS_PROTOTYPE = 8;
    public static final int FLAG_IS_LAZY_INIT = 16;
    public static final int FLAG_IS_ABSTRACT = 32;
    public static final int FLAG_IS_ROOT_BEAN_WITHOUT_CLASS = 64;
    private Image baseImage;
    private int flags;
    private Point size;

    public BeansModelImageDescriptor(Image baseImage, int flags) {
        this.baseImage = baseImage;
        this.flags = flags;
    }

    protected Point getSize() {
        if (this.size == null) {
            ImageData data = this.baseImage.getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.size;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData background = this.baseImage.getImageData();
        if (background == null) {
            background = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(background, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        int x = 0;
        int y = 0;
        ImageData data = null;
        if ((this.flags & 1) != 0) {
            data = BeansUIImages.DESC_OVR_EXTERNAL.getImageData();
            x = this.getSize().x - data.width;
            y = this.getSize().y - data.height;
            this.drawImage(data, x, y);
        }
        if ((this.flags & 2) != 0) {
            data = BeansUIImages.DESC_OVR_ERROR.getImageData();
            x = 0;
            y = this.getSize().y - data.height;
            this.drawImage(data, x, y);
        } else if ((this.flags & 4) != 0) {
            data = BeansUIImages.DESC_OVR_WARNING.getImageData();
            x = 0;
            y = this.getSize().y - data.height;
            this.drawImage(data, x, y);
        }
        if ((this.flags & 8) != 0) {
            data = BeansUIImages.DESC_OVR_PROTOTYPE.getImageData();
            x = 0;
            y = 0;
            this.drawImage(data, x, y);
        }
        if ((this.flags & 0x20) != 0) {
            data = BeansUIImages.DESC_OVR_ABSTRACT.getImageData();
            x = this.getSize().x - data.width;
            y = 0;
            this.drawImage(data, x, y);
        } else if ((this.flags & 0x40) != 0) {
            data = BeansUIImages.DESC_OVR_NO_CLASS.getImageData();
            x = this.getSize().x - data.width;
            y = 0;
            this.drawImage(data, x, y);
        }
    }

    protected void setSize(Point size) {
        this.size = size;
    }

    protected Image getOverlayedImage() {
        return BeansUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)this);
    }
}

