/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hover;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.taginfo.XMLTagInfoHoverProcessor;
import org.springframework.ide.eclipse.beans.core.internal.Introspector;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.editor.BeansEditorUtils;
import org.springframework.ide.eclipse.beans.ui.editor.BeansJavaDocUtils;
import org.springframework.ide.eclipse.beans.ui.editor.BeansLablelProvider;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BeansTextHoverProcessor
extends XMLTagInfoHoverProcessor
implements ITextHover {
    private IEditorPart editor;

    public BeansTextHoverProcessor(IEditorPart editor) {
        this.editor = editor;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String displayText = null;
        int documentOffset = hoverRegion.getOffset();
        displayText = this.computeHoverHelp(textViewer, documentOffset);
        if (displayText != null) {
            return displayText;
        }
        return super.getHoverInfo(textViewer, hoverRegion);
    }

    protected String computeHoverHelp(ITextViewer textViewer, int documentPosition) {
        ITextRegion region;
        String result = null;
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((StructuredTextViewer)((StructuredTextViewer)textViewer), (int)documentPosition);
        if (treeNode == null) {
            return null;
        }
        Node node = (Node)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode parentNode = (IDOMNode)node;
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(documentPosition);
        if (flatNode != null && (region = flatNode.getRegionAtCharacterOffset(documentPosition)) != null) {
            result = this.computeRegionHelp(treeNode, parentNode, flatNode, region);
        }
        return result;
    }

    protected String computeRegionHelp(IndexedRegion treeNode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        String result = null;
        if (region == null) {
            return null;
        }
        String regionType = region.getType();
        if (regionType == "XML_TAG_NAME") {
            result = this.computeTagNameHelp((IDOMNode)treeNode, parentNode, flatNode, region);
        } else if (regionType == "XML_TAG_ATTRIBUTE_NAME") {
            result = this.computeTagAttNameHelp((IDOMNode)treeNode, parentNode, flatNode, region);
        } else if (regionType == "XML_TAG_ATTRIBUTE_VALUE") {
            result = this.computeTagAttValueHelp((IDOMNode)treeNode, parentNode, flatNode, region);
        }
        return result;
    }

    protected String computeTagAttValueHelp(IDOMNode xmlnode, IDOMNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        IFile file = ((IFileEditorInput)this.editor.getEditorInput()).getFile();
        ITextRegion attrNameRegion = this.getAttrNameRegion(xmlnode, region);
        String attName = flatNode.getText(attrNameRegion);
        NamedNodeMap attributes = xmlnode.getAttributes();
        String result = null;
        if ("class".equals(attName) && attributes.getNamedItem("class") != null) {
            IType type;
            String className = attributes.getNamedItem("class").getNodeValue();
            if (className != null && (type = BeansModelUtils.getJavaType((IProject)((IFileEditorInput)this.editor.getEditorInput()).getFile().getProject(), (String)className)) != null) {
                BeansJavaDocUtils utils = new BeansJavaDocUtils((IMember)type);
                result = utils.getJavaDoc();
            }
        } else if ("name".equals(attName) && "property".equals(xmlnode.getNodeName())) {
            NamedNodeMap parentAttributes = xmlnode.getParentNode().getAttributes();
            if (parentAttributes.getNamedItem("class") != null && attributes.getNamedItem(attName) != null) {
                IType type;
                String className = parentAttributes.getNamedItem("class").getNodeValue();
                String propertyName = attributes.getNamedItem(attName).getNodeValue();
                if (className != null && (type = BeansModelUtils.getJavaType((IProject)file.getProject(), (String)className)) != null) {
                    try {
                        IMethod method = Introspector.getWritableProperty((IType)type, (String)propertyName);
                        if (method != null) {
                            BeansJavaDocUtils utils = new BeansJavaDocUtils((IMember)method);
                            result = utils.getJavaDoc();
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
        } else if ("local".equals(attName) && attributes.getNamedItem(attName) != null) {
            Element ref = xmlnode.getOwnerDocument().getElementById(attributes.getNamedItem(attName).getNodeValue());
            result = BeansLablelProvider.createAdditionalProposalInfo(ref, file);
        } else if ("bean".equals(attName) && attributes.getNamedItem(attName) != null) {
            String target = attributes.getNamedItem(attName).getNodeValue();
            Iterator beans = BeansEditorUtils.getBeansFromConfigSets(file).iterator();
            while (beans.hasNext()) {
                IBean modelBean = (IBean)beans.next();
                if (!modelBean.getElementName().equals(target)) continue;
                result = BeansLablelProvider.createAdditionalProposalInfo(modelBean);
            }
        } else if (("parent".equals(attName) || "depends-on".equals(attName) || "factory-bean".equals(attName)) && attributes.getNamedItem(attName) != null) {
            Element ref = xmlnode.getOwnerDocument().getElementById(attributes.getNamedItem(attName).getNodeValue());
            if (ref != null) {
                result = BeansLablelProvider.createAdditionalProposalInfo(ref, file);
            } else {
                String target = attributes.getNamedItem(attName).getNodeValue();
                Iterator beans = BeansEditorUtils.getBeansFromConfigSets(file).iterator();
                while (beans.hasNext()) {
                    IBean modelBean = (IBean)beans.next();
                    if (!modelBean.getElementName().equals(target)) continue;
                    result = BeansLablelProvider.createAdditionalProposalInfo(modelBean);
                }
            }
        }
        if (result != null && !"".equals(result)) {
            return result;
        }
        return super.computeTagAttValueHelp(xmlnode, parentNode, flatNode, attrNameRegion);
    }
}

