/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.grip;

import java.awt.*;

import javax.swing.JComponent;

import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.theme.SubstanceTheme;

/**
 * Implementation of grip painter that uses drag bumps identical to those on
 * toolbars and split pane dividers.
 * 
 * @author Kirill Grouchnikov
 */
public class DragBumpsGripPainter implements GripPainter {
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.utils.GripPainter#paintGrip(javax.swing.JComponent,
	 *      java.awt.Graphics, org.jvnet.substance.theme.SubstanceTheme,
	 *      java.awt.Rectangle, boolean, java.awt.ComponentOrientation)
	 */
	public void paintGrip(JComponent comp, Graphics graphics,
			SubstanceTheme theme, Rectangle gripArea, boolean isGripVertical,
			ComponentOrientation gripOrientation) {
		if (isGripVertical) {
			int thumbHeight = gripArea.height;
			if (thumbHeight < 30)
				return;
			int gripHeight = thumbHeight / 4;
			if (gripHeight > 40)
				gripHeight = 40;

			int thumbWidth = gripArea.width;
			int gripWidth = thumbWidth * 2 / 3;

			int gripX = gripArea.x + (thumbWidth - gripWidth) / 2;
			int gripY = gripArea.y + (thumbHeight - gripHeight) / 2;
			graphics.drawImage(SubstanceImageCreator.getDragImage(comp, theme,
					true, gripWidth, gripHeight, true, -1), gripX, gripY, null);
		} else {
			int thumbWidth = gripArea.width;
			if (thumbWidth < 30)
				return;
			int gripWidth = thumbWidth / 4;
			if (gripWidth > 40)
				gripWidth = 40;

			int thumbHeight = gripArea.height;
			int gripHeight = thumbHeight * 2 / 3;

			int gripX = gripArea.x + (thumbWidth - gripWidth) / 2;
			int gripY = 1 + gripArea.y + (thumbHeight - gripHeight) / 2;
			graphics.drawImage(SubstanceImageCreator.getRotated(
					SubstanceImageCreator.getDragImage(comp, theme, true,
							gripHeight, gripWidth, true, -1), 3), gripX, gripY,
					null);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.grip.GripPainter#getDisplayName()
	 */
	public String getDisplayName() {
		return "Drag Bumps";
	}
}