/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.plugin;

import java.util.HashSet;
import java.util.Set;

import org.jvnet.substance.title.*;

/**
 * Core plugin for title painters shapers. See
 * {@link SubstanceTitlePainterPlugin} interface. This class is <b>for internal
 * use only</b>.
 * 
 * @author Kirill Grouchnikov.
 */
public class BaseTitlePainterPlugin implements SubstanceTitlePainterPlugin {
	/**
	 * Creates info object on a single gradient painter.
	 * 
	 * @param titlePainterName
	 *            Title painter display name.
	 * @param titlePainterClass
	 *            Title painter class.
	 * @param isDefault
	 *            Indication whether the specified title painter is default.
	 * @return Info object on the specified title painter.
	 */
	private static TitlePainterInfo create(String titlePainterName,
			Class<?> titlePainterClass, boolean isDefault) {
		TitlePainterInfo result = new TitlePainterInfo(titlePainterName,
				titlePainterClass.getName());
		result.setDefault(isDefault);
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.plugin.SubstanceGradientPainterPlugin#getGradientPainters()
	 */
	public Set<TitlePainterInfo> getTitlePainters() {
		Set<TitlePainterInfo> result = new HashSet<TitlePainterInfo>();
		result.add(create(Glass3DTitlePainter.DISPLAY_NAME,
				Glass3DTitlePainter.class, false));
		result.add(create(ClassicTitlePainter.DISPLAY_NAME,
				ClassicTitlePainter.class, false));
		result.add(create(RandomCubesTitlePainter.DISPLAY_NAME,
				RandomCubesTitlePainter.class, false));
		result.add(create(ArcHeaderPainter.DISPLAY_NAME,
				ArcHeaderPainter.class, false));
		result.add(create(BrushedMetalHeaderPainter.DISPLAY_NAME,
				BrushedMetalHeaderPainter.class, false));
		result.add(create(MarbleNoiseHeaderPainter.DISPLAY_NAME,
				MarbleNoiseHeaderPainter.class, false));
		result.add(create(FlatTitlePainter.DISPLAY_NAME,
				FlatTitlePainter.class, false));
		result.add(create(MatteHeaderPainter.DISPLAY_NAME,
				MatteHeaderPainter.class, false));
		return result;
	}
}
