/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import java.awt.Color;

import org.jvnet.substance.border.ClassicInnerBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.MetallicColorScheme;
import org.jvnet.substance.painter.*;
import org.jvnet.substance.theme.*;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.title.ArcHeaderPainter;
import org.jvnet.substance.title.BrushedMetalHeaderPainter;
import org.jvnet.substance.utils.SubstanceConstants.ColorShiftKind;
import org.jvnet.substance.watermark.SubstanceNullWatermark;

/**
 * <code>Business</code> skin. This class is part of officially supported API.
 * 
 * @author Kirill Grouchnikov
 * @since version 3.1
 */
public class BusinessSkin extends SubstanceAbstractSkin {
	/**
	 * Display name for <code>this</code> skin.
	 */
	public static String NAME = "Business";

	/**
	 * Creates a new <code>Business</code> skin.
	 */
	public BusinessSkin() {
		SubstanceTheme activeTheme = new SubstanceTheme(
				new MetallicColorScheme(), "Tint Metallic", ThemeKind.COLD)
				.tint(0.15);
		SubstanceTheme defaultTheme = new SubstanceTheme(
				new MetallicColorScheme(), "Shade Metallic", ThemeKind.COLD)
				.shade(0.1);
		SubstanceTheme disabledTheme = defaultTheme.getDisabledTheme()
				.tint(0.2);
		SubstanceTheme activeTitleTheme = defaultTheme;

		SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME,
				ThemeKind.COLD, activeTheme, defaultTheme, disabledTheme,
				activeTitleTheme) {
			@Override
			public Color getLightBackgroundColor() {
				return disabledTheme.getBackgroundColor();
			}
		};
		theme.registerComponentHighlightStateTheme(new SubstanceBlendBiTheme(
				new SubstanceTerracottaTheme(), new SubstanceSunGlareTheme(),
				0.5).tint(0.2));
		theme.setSelectedTabFadeStart(0.6);
		theme.setSelectedTabFadeEnd(1.0);
		theme
				.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
		this.theme = theme;
		// theme.addPaintAsActive(JScrollBar.class);
		this.shaper = new ClassicButtonShaper();
		this.watermark = new SubstanceNullWatermark();
		this.gradientPainter = new ClassicGradientPainter();

		BrushedMetalHeaderPainter titlePainter = new BrushedMetalHeaderPainter();
		titlePainter.setBaseTitlePainter(new ArcHeaderPainter());
		titlePainter.setTextureAlpha(0.2f);
		this.titlePainter = titlePainter;

		this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.5f);

		this.borderPainter = new ClassicInnerBorderPainter(0.9f,
				ColorShiftKind.TINT);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return NAME;
	}
}
