/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import java.awt.Color;

import org.jvnet.substance.border.GlassInnerBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.LightGrayColorScheme;
import org.jvnet.substance.painter.*;
import org.jvnet.substance.theme.*;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.title.ArcHeaderPainter;
import org.jvnet.substance.utils.SubstanceConstants.ColorShiftKind;
import org.jvnet.substance.watermark.SubstanceNullWatermark;

/**
 * <code>Creme Coffee</code> skin. This class is part of officially supported
 * API.
 * 
 * @author Kirill Grouchnikov
 * @since version 4.1
 */
public class CremeCoffeeSkin extends SubstanceAbstractSkin {
	/**
	 * Color scheme for active visual state.
	 * 
	 * @author Kirill Grouchnikov
	 */
	protected static class ActiveScheme implements ColorScheme {
		/**
		 * The main ultra-light color.
		 */
		private static final Color mainUltraLightColor = new Color(244, 229,
				192);

		/**
		 * The main extra-light color.
		 */
		private static final Color mainExtraLightColor = new Color(240, 222,
				179);

		/**
		 * The main light color.
		 */
		private static final Color mainLightColor = new Color(235, 215, 166);

		/**
		 * The main medium color.
		 */
		private static final Color mainMidColor = new Color(200, 162, 110);

		/**
		 * The main dark color.
		 */
		private static final Color mainDarkColor = new Color(170, 131, 99);

		/**
		 * The main ultra-dark color.
		 */
		private static final Color mainUltraDarkColor = new Color(141, 97, 44);

		/**
		 * The foreground color.
		 */
		private static final Color foregroundColor = new Color(50, 34, 15);

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getForegroundColor()
		 */
		public Color getForegroundColor() {
			return ActiveScheme.foregroundColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraLightColor()
		 */
		public Color getUltraLightColor() {
			return ActiveScheme.mainUltraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getExtraLightColor()
		 */
		public Color getExtraLightColor() {
			return ActiveScheme.mainExtraLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getLightColor()
		 */
		public Color getLightColor() {
			return ActiveScheme.mainLightColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getMidColor()
		 */
		public Color getMidColor() {
			return ActiveScheme.mainMidColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getDarkColor()
		 */
		public Color getDarkColor() {
			return ActiveScheme.mainDarkColor;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jvnet.substance.color.ColorScheme#getUltraDarkColor()
		 */
		public Color getUltraDarkColor() {
			return ActiveScheme.mainUltraDarkColor;
		}
	}

	/**
	 * Display name for <code>this</code> skin.
	 */
	public static String NAME = "Creme Coffee";

	/**
	 * Creates a new <code>Creme Coffee</code> skin.
	 */
	public CremeCoffeeSkin() {
		SubstanceTheme activeTheme = new SubstanceTheme(new ActiveScheme(),
				"Creme Coffee Active", ThemeKind.COLD);
		//			
		// new SubstanceBrownTheme().tint(0.7)
		// .saturate(0.2);
		SubstanceTheme defaultTheme = new SubstanceCremeTheme();
		SubstanceTheme disabledTheme = new SubstanceTheme(
				new LightGrayColorScheme(), "Tint Light Gray", ThemeKind.COLD)
				.tint(0.35);
		SubstanceTheme activeTitleTheme = defaultTheme;

		SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME,
				ThemeKind.COLD, activeTheme, defaultTheme, disabledTheme,
				activeTitleTheme);
		theme
				.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
		theme.setSelectedTabFadeStart(0.1);
		theme.setSelectedTabFadeEnd(0.3);
		this.theme = theme;

		this.shaper = new ClassicButtonShaper();
		this.watermark = new SubstanceNullWatermark();
		this.gradientPainter = new MatteGradientPainter(false);
		this.titlePainter = new ArcHeaderPainter();
		this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.75f);

		this.borderPainter = new GlassInnerBorderPainter(0.8f,
				ColorShiftKind.TINT);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return NAME;
	}
}