/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import java.awt.Color;

import org.jvnet.substance.border.ClassicInnerBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.ShadeColorScheme;
import org.jvnet.substance.painter.*;
import org.jvnet.substance.theme.*;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.title.ArcHeaderPainter;
import org.jvnet.substance.utils.SubstanceConstants.ColorShiftKind;
import org.jvnet.substance.watermark.SubstanceCrosshatchWatermark;

/**
 * <code>Raven Graphite Glass</code> skin. This class is part of officially
 * supported API.
 * 
 * @author Kirill Grouchnikov
 * @since version 3.3
 */
public class RavenGraphiteGlassSkin extends SubstanceAbstractSkin {
	/**
	 * Display name for <code>this</code> skin.
	 */
	public static String NAME = "Raven Graphite Glass";

	/**
	 * Creates a new <code>Raven Graphite</code> skin.
	 */
	public RavenGraphiteGlassSkin() {
		SubstanceTheme activeTheme = new SubstanceEbonyTheme().tint(0.2);
		SubstanceTheme defaultTheme = activeTheme.shade(0.2);

		ColorScheme disabledScheme = new ShadeColorScheme(activeTheme
				.getColorScheme(), 0.3) {
			Color foreColor = new Color(110, 110, 110);

			@Override
			public Color getForegroundColor() {
				return foreColor;
			}
		};
		SubstanceTheme disabledTheme = new SubstanceTheme(disabledScheme,
				"Shaded 30% Tinted Ebony 20%", ThemeKind.DARK);
		SubstanceTheme activeTitleTheme = defaultTheme;

		SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME,
				ThemeKind.DARK, activeTheme, defaultTheme, disabledTheme,
				activeTitleTheme);
		theme
				.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
		theme.setSelectedTabFadeStart(0.3);
		theme.setSelectedTabFadeEnd(0.6);
		theme.registerComponentHighlightStateTheme(new SubstanceEbonyTheme());

		this.theme = theme;
		this.shaper = new ClassicButtonShaper();
		this.watermark = new SubstanceCrosshatchWatermark();
		this.gradientPainter = new GlassGradientPainter();
		this.titlePainter = new ArcHeaderPainter();
		this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.5f);
		this.borderPainter = new ClassicInnerBorderPainter(0.5f, ColorShiftKind.TONE);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return NAME;
	}
}
