/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.utils.params;

import org.jvnet.substance.border.SubstanceBorderPainter;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.utils.SubstanceConstants.ImageWatermarkKind;
import org.jvnet.substance.watermark.SubstanceImageWatermark;
import org.jvnet.substance.watermark.SubstanceWatermark;

/**
 * Base interface for parameter readers. This class is <b>for internal use only</b>.
 * 
 * @author Kirill Grouchnikov
 */
public interface ParamReader {
	/**
	 * Returns the value that specifies the global <b>Substance</b> theme. If
	 * not <code>null</code>, should be a fully-qualified class name of a
	 * class that extends {@link SubstanceTheme}.
	 * 
	 * @return The value that specifies the global <b>Substance</b> theme. If
	 *         not <code>null</code>, should be a fully-qualified class name
	 *         of a class that extends {@link SubstanceTheme}.
	 */
	public String getThemeProperty();

	/**
	 * Returns the value that specifies the global <b>Substance</b> watermark.
	 * If not <code>null</code>, should be a fully-qualified class name of a
	 * class that implements {@link SubstanceWatermark}.
	 * 
	 * @return The value that specifies the global <b>Substance</b> watermark.
	 *         If not <code>null</code>, should be a fully-qualified class
	 *         name of a class that implements {@link SubstanceWatermark}.
	 */
	public String getWatermarkProperty();

	/**
	 * Returns the value that specifies the image location for image-based
	 * watermark. This value is relevant only if the
	 * {@link #getWatermarkProperty()} returns the class name of
	 * {@link SubstanceImageWatermark}. The value can point at either the local
	 * file or remote HTTP-based file.
	 * 
	 * @return The value that specifies the image location for image-based
	 *         watermark.
	 */
	public String getWatermarkImageProperty();

	/**
	 * Returns the value that specifies the kind of image-based watermark. This
	 * value is relevant only if the {@link #getWatermarkProperty()} returns the
	 * class name of {@link SubstanceImageWatermark}.
	 * 
	 * @return The value that specifies the kind of image-based watermark.
	 */
	public ImageWatermarkKind getWatermarkImageKindProperty();

	/**
	 * Returns the value that specifies the opacity of image-based watermark.
	 * This value is relevant only if the {@link #getWatermarkProperty()}
	 * returns the class name of {@link SubstanceImageWatermark}.
	 * 
	 * @return The value that specifies the opacity of image-based watermark.
	 */
	public Float getWatermarkImageOpacityProperty();

	/**
	 * Returns indication whether the watermark should "bleed" through usuallu
	 * opaque controls, such as trees, lists, tables and text controls (text
	 * field, text area, etc).
	 * 
	 * @return Indication whether the watermark should "bleed" through usuallu
	 *         opaque controls.
	 */
	public boolean toBleedWatermark();

	/**
	 * Returns the value that specifies the global <b>Substance</b> button
	 * shaper. If not <code>null</code>, should be a fully-qualified class
	 * name of a class that implements {@link SubstanceButtonShaper}.
	 * 
	 * @return The value that specifies the global <b>Substance</b> button
	 *         shaper. If not <code>null</code>, should be a fully-qualified
	 *         class name of a class that implements
	 *         {@link SubstanceButtonShaper}.
	 */
	public String getButtonShaperProperty();

	/**
	 * Returns the value that specifies the global <b>Substance</b> gradient
	 * painter. If not <code>null</code>, should be a fully-qualified class
	 * name of a class that implements {@link SubstanceGradientPainter}.
	 * 
	 * @return The value that specifies the global <b>Substance</b> gradient
	 *         painter. If not <code>null</code>, should be a fully-qualified
	 *         class name of a class that implements
	 *         {@link SubstanceGradientPainter}.
	 */
	public String getGradientPainterProperty();

	/**
	 * Returns the value that specifies the global <b>Substance</b> title
	 * painter. If not <code>null</code>, should be a fully-qualified class
	 * name of a class that implements {@link SubstanceTitlePainter}.
	 * 
	 * @return The value that specifies the global <b>Substance</b> title
	 *         painter. If not <code>null</code>, should be a fully-qualified
	 *         class name of a class that implements
	 *         {@link SubstanceTitlePainter}.
	 */
	public String getTitlePainterProperty();

	/**
	 * Returns the value that specifies the global <b>Substance</b> border
	 * painter. If not <code>null</code>, should be a fully-qualified class
	 * name of a class that implements {@link SubstanceBorderPainter}.
	 * 
	 * @return The value that specifies the global <b>Substance</b> border
	 *         painter. If not <code>null</code>, should be a fully-qualified
	 *         class name of a class that implements
	 *         {@link SubstanceBorderPainter}.
	 */
	public String getBorderPainterProperty();

	/**
	 * Returns the indication for showing the heap status panel in the
	 * custom-decorated title panes. If the value is <code>null</code>, no
	 * heap status panel will be shown, if the value is an empty string, the
	 * heap status panel will be shown. Otherwise, the value is taken to be the
	 * filename for logging the heap status information (and the heap status
	 * panel will be shown).
	 * 
	 * @return Indication for showing the heap status panel in the
	 *         custom-decorated title panes. Possible return values:
	 *         <ul>
	 *         <li>If the value is <code>null</code>, no heap status panel
	 *         will be shown.
	 *         <li>If the value is an empty string, the heap status panel will
	 *         be shown.
	 *         <li>Otherwise, the value is taken to be the filename for logging
	 *         the heap status information (and the heap status panel will be
	 *         shown).
	 *         </ul>
	 */
	public String toShowHeapStatusPanelProperty();

	/**
	 * Returns the indication whether <b>Substance</b> can add additional UI
	 * elements (such as system menu items, menu search panel).
	 * 
	 * @return <code>true</code> if <b>Substance</b> can add additional UI
	 *         elements (such as system menu items, menu search panel),
	 *         <code>false</code> otherwise.
	 */
	public boolean toShowExtraElementProperty();

	/**
	 * Returns the name of the trace file. The trace file will contain output of
	 * the memory analyser which can be used to pinpoint the memory leaks.
	 * 
	 * @return The name of the trace file for memory analysis. If
	 *         <code>null</code>, the tracing mechanism will not be
	 *         activated.
	 */
	public String getTraceFileNameProperty();

	/**
	 * Returns the indication whether <b>Substance</b> should enable inverted
	 * color themes.
	 * 
	 * @return <code>true</code> if <b>Substance</b> should enable inverted
	 *         color themes, <code>false</code> otherwise.
	 */
	public boolean toEnableInvertedThemes();

	/**
	 * Returns the indication whether <b>Substance</b> should enable negated
	 * color themes.
	 * 
	 * @return <code>true</code> if <b>Substance</b> should enable negated
	 *         color themes, <code>false</code> otherwise.
	 */
	public boolean toEnableNegatedThemes();

	/**
	 * Returns the indication whether <b>Substance</b> is running the
	 * application under debug UI mode.
	 * 
	 * @return <code>true</code> if <b>Substance</b> is running the
	 *         application under debug UI mode, <code>false</code> otherwise.
	 */
	public boolean isDebugUiMode();
}
