package test;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;
import javax.swing.plaf.FontUIResource;

import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.utils.LafConstants.AnimationKind;
import org.jvnet.substance.SubstanceDefaultComboBoxRenderer;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.fonts.FontPolicy;
import org.jvnet.substance.fonts.FontSet;
import org.jvnet.substance.skin.SubstanceModerateLookAndFeel;

public class ButtonRolloverDemo extends JFrame {
	/**
	 * Wrapper around the base Substance font set. Is used to create larger /
	 * smaller font sets.
	 * 
	 * @author Kirill Grouchnikov
	 */
	private static class WrapperFontSet implements FontSet {
		/**
		 * Extra size in pixels. Can be positive or negative.
		 */
		private int extra;

		/**
		 * The base Substance font set.
		 */
		private FontSet delegate;

		/**
		 * Creates a wrapper font set.
		 * 
		 * @param delegate
		 *            The base Substance font set.
		 * @param extra
		 *            Extra size in pixels. Can be positive or negative.
		 */
		public WrapperFontSet(FontSet delegate, int extra) {
			super();
			this.delegate = delegate;
			this.extra = extra;
		}

		/**
		 * Returns the wrapped font.
		 * 
		 * @param systemFont
		 *            Original font.
		 * @return Wrapped font.
		 */
		private FontUIResource getWrappedFont(FontUIResource systemFont) {
			return new FontUIResource(systemFont.getFontName(), systemFont
					.getStyle(), systemFont.getSize() + extra);
		}

		public FontUIResource getControlFont() {
			return getWrappedFont(delegate.getControlFont());
		}

		public FontUIResource getMenuFont() {
			return getWrappedFont(delegate.getMenuFont());
		}

		public FontUIResource getMessageFont() {
			return getWrappedFont(delegate.getMessageFont());
		}

		public FontUIResource getSmallFont() {
			return getWrappedFont(delegate.getSmallFont());
		}

		public FontUIResource getTitleFont() {
			return getWrappedFont(delegate.getTitleFont());
		}

		public FontUIResource getWindowTitleFont() {
			return getWrappedFont(delegate.getWindowTitleFont());
		}
	}

	public ButtonRolloverDemo() {
		super("Ghost effects");

		setLayout(new BorderLayout());
		final JPanel buttons = new JPanel(new FlowLayout());
		JButton cutButton = new JButton("Cut", new ImageIcon(
				ButtonRolloverDemo.class
						.getResource("/test/icons/edit-cut.png")));
		cutButton.setFocusPainted(false);
		buttons.add(cutButton);
		// buttons.add(new JButton("Copy", new ImageIcon(ButtonRolloverDemo.class
		// .getResource("/test/icons/edit-copy.png"))));
		JButton copyButton = new JButton("Paste", new ImageIcon(
				ButtonRolloverDemo.class
						.getResource("/test/icons/edit-paste.png")));
		copyButton.setFocusPainted(false);
		buttons.add(copyButton);
		JButton deleteButton = new JButton("Delete", new ImageIcon(
				ButtonRolloverDemo.class
						.getResource("/test/icons/edit-delete.png")));
		deleteButton.setFocusPainted(false);
		buttons.add(deleteButton);
		// buttons.add(new JButton("Paste", new ImageIcon(ButtonRolloverDemo.class
		// .getResource("/test/icons/edit-paste.png"))));
		// buttons.add(new JButton("Delete", new ImageIcon(
		// ButtonRolloverDemo.class
		// .getResource("/test/icons/edit-delete.png"))));
		// buttons.add(new JButton("Select All", new ImageIcon(
		// ButtonRolloverDemo.class
		// .getResource("/test/icons/edit-select-all.png"))));

		this.add(buttons, BorderLayout.CENTER);

		JPanel controls = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		controls.setBackground(new Color(255, 240, 150));
		final JComboBox animKindCombo = new JComboBox(new Object[] {
				AnimationKind.NONE, AnimationKind.FAST, AnimationKind.REGULAR,
				AnimationKind.SLOW });
		animKindCombo.setRenderer(new SubstanceDefaultComboBoxRenderer(animKindCombo) {
			@Override
			public Component getListCellRendererComponent(JList list,
					Object value, int index, boolean isSelected,
					boolean cellHasFocus) {
				AnimationKind ak = (AnimationKind) value;
				return super.getListCellRendererComponent(list, ak.getName(),
						index, isSelected, cellHasFocus);
			}
		});
		animKindCombo.setSelectedItem(LafWidgetUtilities
				.getAnimationKind(buttons));
		controls.add(animKindCombo);
		animKindCombo.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				buttons.putClientProperty(LafWidget.ANIMATION_KIND,
						animKindCombo.getSelectedItem());
			}
		});
		this.add(controls, BorderLayout.SOUTH);

		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setSize(400, 150);
		setLocationRelativeTo(null);
	}

	public static void main(String[] args) throws Exception {
		JFrame.setDefaultLookAndFeelDecorated(true);
		UIManager.setLookAndFeel(new SubstanceModerateLookAndFeel());

		final FontSet substanceCoreFontSet = SubstanceLookAndFeel
				.getFontPolicy().getFontSet("Substance", null);
		// Create the wrapper font set
		FontPolicy newFontPolicy = new FontPolicy() {
			public FontSet getFontSet(String lafName, UIDefaults table) {
				return new WrapperFontSet(substanceCoreFontSet, 6);
			}
		};

		// set the new font policy
		SubstanceLookAndFeel.setFontPolicy(newFontPolicy);
		// reset the LAF to have the changes
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());

		FadeConfigurationManager.getInstance().allowFades(
				FadeKind.GHOSTING_ICON_ROLLOVER);
		FadeConfigurationManager.getInstance().allowFades(
				FadeKind.GHOSTING_BUTTON_PRESS);
		FadeConfigurationManager.getInstance().allowFades(FadeKind.ICON_GLOW);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new ButtonRolloverDemo().setVisible(true);
			}
		});

	}
}
