package test;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.SubstanceOrangeTheme;
import org.jvnet.substance.title.ClassicTitlePainter;
import org.jvnet.substance.watermark.SubstanceNullWatermark;

public class CheckMenuSearchPanel extends JFrame {

	public CheckMenuSearchPanel() {
		super("Test");

		this.setLayout(new FlowLayout());
		JButton button = new JButton("click me");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						try {
							SubstanceLookAndFeel
									.setCurrentTheme(new SubstanceOrangeTheme());
							SubstanceLookAndFeel
									.setCurrentWatermark(new SubstanceNullWatermark());
							SubstanceLookAndFeel
									.setCurrentTitlePainter(new ClassicTitlePainter());
							UIManager.put(
									SubstanceLookAndFeel.NO_EXTRA_ELEMENTS,
									Boolean.TRUE);
							UIManager
									.put(
											SubstanceLookAndFeel.TABBED_PANE_VERTICAL_ORIENTATION,
											Boolean.TRUE);
							UIManager
									.setLookAndFeel(new SubstanceLookAndFeel());
							SwingUtilities
									.updateComponentTreeUI(CheckMenuSearchPanel.this);
						} catch (Exception exc) {
						}
					}
				});
			}
		});
		this.add(button);

		JMenuBar jmb = new JMenuBar();
		for (int i = 0; i < 5; i++) {
			JMenu menu = new JMenu("menu" + i);
			for (int j = 0; j < 15; j++) {
				menu.add(new JMenuItem("menu item " + j));
			}
			jmb.add(menu);
		}
		this.setJMenuBar(jmb);

		this.setSize(300, 200);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		JFrame.setDefaultLookAndFeelDecorated(true);
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new CheckMenuSearchPanel().setVisible(true);
			}
		});
	}
}
