package test;

import java.awt.*;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;

public class ListTest extends JFrame {
	private class CustomListCellRenderer extends JLabel implements
			ListCellRenderer {

		Font font = getFont();

		public CustomListCellRenderer() {
			setOpaque(true);
			setHorizontalAlignment(LEFT);
			setVerticalAlignment(CENTER);
			setFont(font);
		}

		public Component getListCellRendererComponent(JList list, Object value,
				int index, boolean isSelected, boolean cellHasFocus) {
			setText((String) value);
			setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
			return this;
		}
	}

	public ListTest() {
		this.setLayout(new FlowLayout());

		JList list = new JList(new Object[] { "item1", "item2", "item3" });
		list.setCellRenderer(new CustomListCellRenderer());
		this.add(list);

		this.setSize(200, 200);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new ListTest().setVisible(true);
			}
		});
	}
}
