package test;

import java.awt.*;

import javax.swing.*;

import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;

public class Toolbars extends JFrame {
	protected static class SampleIcon implements Icon {
		public int getIconHeight() {
			return 10;
		}

		public int getIconWidth() {
			return 10;
		}

		public void paintIcon(Component c, Graphics g, int x, int y) {
			g.setColor(Color.red);
			g.fillRect(x, y, 10, 10);
		}
	}

	public Toolbars() {
		super("Some simple text");
		setLayout(new BorderLayout());

		JToolBar jtb = new JToolBar();
		jtb.add(new JButton(new SampleIcon()));
		jtb.add(new JToggleButton(new SampleIcon()));

		JToolBar inner = new JToolBar();
		inner.setFloatable(false);

		JButton b = new JButton(new SampleIcon());
		b.setBorderPainted(false);
		b.setFocusPainted(false);
		b.setContentAreaFilled(false);

		JPanel p = new JPanel();
		p.setName("panel1");
		p.add(b);
		inner.add(p);
		inner.add(new JToggleButton(new SampleIcon()));
		jtb.add(inner);

		JToolBar inner2 = new JToolBar();
		inner2.setFloatable(false);
		inner2.add(new JButton(new SampleIcon()));
		inner2.add(new JToggleButton(new SampleIcon()));
		JPanel innerPanel = new JPanel(new BorderLayout());
		innerPanel.setName("panel2");
		innerPanel.add(inner2);
		jtb.add(innerPanel);

		this.add(jtb, BorderLayout.NORTH);

		JMenuBar jmb = new JMenuBar();
		jmb.add(new JMenu("File"));
		jmb.add(new JMenu("Edit"));
		jmb.add(new JMenu("Source"));
		jmb.add(new JMenu("Run"));
		setJMenuBar(jmb);

		this.setSize(650, 400);
		setLocationRelativeTo(null);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		// FadeTracker.DEBUG_MODE = true;
		JFrame.setDefaultLookAndFeelDecorated(true);
		UIManager.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
		// JFrame.setDefaultLookAndFeelDecorated(true);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new Toolbars().setVisible(true);
			}
		});
	}
}
