/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package test.check;

import javax.swing.*;
import javax.swing.border.TitledBorder;

import org.jvnet.lafwidget.LafWidget;

/**
 * Test application panel for testing {@link JSpinner} component.
 * 
 * @author Kirill Grouchnikov
 */
public class SpinnerPanel extends JPanel {
	/**
	 * Creates a test panel with spinners.
	 */
	public SpinnerPanel() {
		this.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));

		JPanel enabledPanel = new JPanel();
		enabledPanel.setLayout(new BoxLayout(enabledPanel, BoxLayout.Y_AXIS));

		JPanel basicEnPanel = new JPanel();
		basicEnPanel.setBorder(new TitledBorder("Basic Spinner"));
		JSpinner basicEnSpinner = new JSpinner();
		basicEnPanel.add(basicEnSpinner);
		enabledPanel.add(basicEnPanel);

		JPanel dateEnPanel = new JPanel();
		dateEnPanel.setBorder(new TitledBorder("Date Spinner"));
		JSpinner dateEnSpinner = new JSpinner(new SpinnerDateModel());
		dateEnPanel.add(dateEnSpinner);
		enabledPanel.add(dateEnPanel);

		String weekdaysEn[] = new String[] { "Sunday", "Monday", "Tuesday",
				"Wednesday", "Thursday", "Friday", "Saturday" };
		JPanel listEnPanel = new JPanel();
		listEnPanel.setBorder(new TitledBorder("List Spinner"));
		JSpinner listEnSpinner = new JSpinner(new SpinnerListModel(weekdaysEn));
		listEnSpinner.putClientProperty(LafWidget.TEXT_SELECT_ON_FOCUS,
				Boolean.TRUE);
		listEnPanel.add(listEnSpinner);
		enabledPanel.add(listEnPanel);

		JPanel numberEnPanel = new JPanel();
		numberEnPanel.setBorder(new TitledBorder("Number Spinner"));
		JSpinner numberEnSpinner = new JSpinner(new SpinnerNumberModel(0, 0,
				100, 5));
		numberEnPanel.add(numberEnSpinner);
		enabledPanel.add(numberEnPanel);

		// basicEnSpinner.setPreferredSize(dateEnSpinner.getPreferredSize());
		// listEnSpinner.setPreferredSize(dateEnSpinner.getPreferredSize());
		// numberEnSpinner.setPreferredSize(dateEnSpinner.getPreferredSize());

		this.add(enabledPanel);

		JPanel disabledPanel = new JPanel();
		disabledPanel.setLayout(new BoxLayout(disabledPanel, BoxLayout.Y_AXIS));

		JPanel basicDisPanel = new JPanel();
		basicDisPanel.setBorder(new TitledBorder("Basic Spinner"));
		JSpinner basicDisSpinner = new JSpinner();
		basicDisSpinner.setEnabled(false);
		basicDisPanel.add(basicDisSpinner);
		disabledPanel.add(basicDisPanel);

		JPanel dateDisPanel = new JPanel();
		dateDisPanel.setBorder(new TitledBorder("Date Spinner"));
		JSpinner dateDisSpinner = new JSpinner(new SpinnerDateModel());
		dateDisSpinner.setEnabled(false);
		dateDisPanel.add(dateDisSpinner);
		disabledPanel.add(dateDisPanel);

		String weekdaysDis[] = new String[] { "Sunday", "Monday", "Tuesday",
				"Wednesday", "Thursday", "Friday", "Saturday" };
		JPanel listDisPanel = new JPanel();
		listDisPanel.setBorder(new TitledBorder("List Spinner"));
		JSpinner listDisSpinner = new JSpinner(
				new SpinnerListModel(weekdaysDis));
		listDisSpinner.setEnabled(false);
		listDisPanel.add(listDisSpinner);
		disabledPanel.add(listDisPanel);

		JPanel numberDisPanel = new JPanel();
		numberDisPanel.setBorder(new TitledBorder("Number Spinner"));
		JSpinner numberDisSpinner = new JSpinner(new SpinnerNumberModel(0, 0,
				100, 5));
		numberDisSpinner.setEnabled(false);
		numberDisPanel.add(numberDisSpinner);
		disabledPanel.add(numberDisPanel);

		// basicDisSpinner.setPreferredSize(dateDisSpinner.getPreferredSize());
		// listDisSpinner.setPreferredSize(dateDisSpinner.getPreferredSize());
		// numberDisSpinner
		// .setPreferredSize(dateDisSpinner.getPreferredSize());

		this.add(disabledPanel);
	}
}