/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package test.check;

import java.awt.BorderLayout;

import javax.swing.*;

import org.jvnet.lafwidget.LafWidget;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.ThemeChangeListener;

/**
 * Test application panel for testing {@link JTabbedPane} component.
 * 
 * @author Kirill Grouchnikov
 */
public class TabPanel extends ControllablePanel {
	/**
	 * Tabbed pane.
	 */
	public JTabbedPane jtp;

	/**
	 * Creates a test panel with tabbed pane.
	 */
	public TabPanel() {
		this.setLayout(new BorderLayout());
		jtp = new JTabbedPane();
		NumberedPanel tnp1 = new NumberedPanel(1);
		tnp1
				.putClientProperty(
						SubstanceLookAndFeel.TABBED_PANE_VERTICAL_ORIENTATION_ROTATE_ICONS,
						Boolean.TRUE);
		jtp.addTab("tab0", null, new JPanel());
		jtp.addTab("tab1", SubstanceImageCreator.getThemeIcon(null), tnp1);
		jtp.addTab("tab 2", SubstanceImageCreator.getThemeIcon(null),
				new NumberedPanel(2));
		NumberedPanel tnp3 = new NumberedPanel(3);
		tnp3
				.putClientProperty(
						SubstanceLookAndFeel.TABBED_PANE_VERTICAL_ORIENTATION_ROTATE_ICONS,
						Boolean.TRUE);
		jtp.addTab("tab  3", SubstanceImageCreator.getThemeIcon(null), tnp3);
		final NumberedPanel np4 = new NumberedPanel(4);
		jtp.addTab("tab   4", new ImageIcon(SubstanceImageCreator
				.getBigHexaMarker(4, SubstanceLookAndFeel.getTheme())), np4);
		final NumberedPanel np5 = new NumberedPanel(5);
		jtp.addTab("tab    5", new ImageIcon(SubstanceImageCreator
				.getBigHexaMarker(5, SubstanceLookAndFeel.getTheme())), np5);
		SubstanceLookAndFeel
				.registerThemeChangeListener(new ThemeChangeListener() {
					public void themeChanged() {
						int index4 = jtp.indexOfComponent(np4);
						if (index4 >= 0) {
							jtp.setIconAt(index4, SubstanceImageCreator
									.getHexaMarker(4, SubstanceLookAndFeel
											.getTheme()));
						}
						int index5 = jtp.indexOfComponent(np5);
						if (index5 >= 0) {
							jtp.setIconAt(index5, SubstanceImageCreator
									.getHexaMarker(5, SubstanceLookAndFeel
											.getTheme()));
						}
					}
				});

		jtp.setEnabledAt(2, false);
		jtp.setEnabledAt(3, false);
		this.add(jtp, BorderLayout.CENTER);

		try {
			MyTabPreviewPainter previewPainter = new MyTabPreviewPainter();
			jtp.putClientProperty(LafWidget.TABBED_PANE_PREVIEW_PAINTER,
					previewPainter);
			this.controlPanel = new TabControlPanel(jtp, previewPainter);
		} catch (NoClassDefFoundError ncdfe) {
			this.controlPanel = new TabControlPanel(jtp, null);
		} catch (Throwable e) {
		}

		// this.setPreferredSize(new Dimension(400, 400));
		// this.setSize(this.getPreferredSize());
		// this.setMinimumSize(this.getPreferredSize());
	}

}