package test.contrib;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.util.*;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.ThemeInfo;
import org.jvnet.substance.watermark.WatermarkInfo;

public class MenuBarTest extends JFrame {
	private static Map<String, ThemeInfo> themes = null;
	private static Map<String, WatermarkInfo> wms = null;
	private static JMenuBar menuBar = new JMenuBar();
	private static Vector<JMenuItem> colorOptions = new Vector();
	private static Vector<JMenuItem> bgOptions = new Vector();
	private static JPanel panel = new JPanel();
	private static JPanel menuBarPanel = new JPanel();

	// ----------------------------------------------------------------------------
	// 
	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		MenuBarTest mbt = new MenuBarTest();
		mbt.createFrame();

	}

	// ----------------------------------------------------------------------------
	//
	public void createFrame() {
		try {
			UIManager.setLookAndFeel(new SubstanceLookAndFeel());
			// SubstanceLookAndFeel.setCurrentTheme("org.jvnet.substance.theme.SubstanceOliveTheme");
		} catch (Exception e) {
			System.out.println("Could not set initial look an feel");
		}

		String[] menuNames = { "File", "Edit", "View" };

		for (String menuName : menuNames) {
			JMenu jM = new JMenu(menuName);
			menuBar.add(jM);
		}

		getSkins();
		JMenu mnuSkins = new JMenu("Substance");
		JMenu mnuColors = new JMenu("Colors");
		JMenu mnuThemes = new JMenu("Themes");

		for (JMenuItem jmi : colorOptions) {
			mnuColors.add(jmi);
		}

		for (JMenuItem jmi : bgOptions) {
			mnuThemes.add(jmi);
		}

		mnuSkins.add(mnuColors);
		mnuSkins.add(mnuThemes);
		menuBar.add(mnuSkins);
		menuBarPanel.add(menuBar);

		setJMenuBar(menuBar);

		JButton btn1 = new JButton("Button 1 on Panel 1");
		panel.add(btn1);
		getContentPane().add(panel, BorderLayout.CENTER);

		setVisible(true);

		setSize(500, 300);
		setLocation(250, 250);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		// pack();
	}

	// ----------------------------------------------------------------------------
	//
	public void getSkins() {
		themes = new SubstanceLookAndFeel().getAllThemes();

		Iterator iter = themes.keySet().iterator();
		while (iter.hasNext()) {
			String nxtTheme = (String) iter.next();
			JMenuItem jmItem = new JMenuItem();
			jmItem.setText(nxtTheme);
			jmItem.addActionListener(new ChangeColorAction());
			colorOptions.add(jmItem);
		}

		wms = new SubstanceLookAndFeel().getAllWatermarks();

		iter = wms.keySet().iterator();
		//       
		while (iter.hasNext()) {
			String nxtWM = (String) iter.next();
			JMenuItem jmItem = new JMenuItem();

			if (nxtWM.equalsIgnoreCase("NULL"))
				nxtWM = "None";

			jmItem.setText(nxtWM);
			jmItem.addActionListener(new ChangeWMAction());
			bgOptions.add(jmItem);
		}
	}

	// ----------------------------------------------------------------------------
	//
	public class ChangeColorAction extends AbstractAction {
		public ChangeColorAction() {
		}

		// --------------------------------------------------------------------------
		public void actionPerformed(ActionEvent e) {
			JMenuItem source = (JMenuItem) (e.getSource());
			String newTheme = themes.get(source.getText()).getClassName();

			try {
				SubstanceLookAndFeel.setCurrentTheme(newTheme);
				UIManager.setLookAndFeel(newTheme);
				// UIManager.setLookAndFeel(newTheme);
			} catch (Exception ee) {
				System.out.println("Can't Change Color");
			} finally {
				updateComponenets();
			}

		}
	}

	// ----------------------------------------------------------------------------
	//
	public class ChangeWMAction extends AbstractAction {
		public ChangeWMAction() {
		}

		// --------------------------------------------------------------------------
		public void actionPerformed(ActionEvent e) {
			JMenuItem source = (JMenuItem) (e.getSource());
			String newWM = source.getText();

			if (newWM.equalsIgnoreCase("None")) {
				newWM = wms.get("Null").getClassName();
			} else {
				try {
					newWM = wms.get(newWM).getClassName();
					SubstanceLookAndFeel.setCurrentWatermark(newWM);
				} catch (Exception ee) {
					System.out.println("Can't Change BG");
				} finally {
					updateComponenets();
				}
			}
		}
	}

	public void updateComponenets() {
		SwingUtilities.updateComponentTreeUI(panel);
		SwingUtilities.updateComponentTreeUI(menuBarPanel);
	}
}
