package test.contrib;

import java.awt.*;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Vector;

import javax.swing.*;
import javax.swing.table.*;

import org.jvnet.substance.SubstanceLookAndFeel;

/**
 * Illustrates issue with latest substance build...
 * 
 * @author Tito Ingargiola
 */
public class TableHeaderNPE extends JPanel {
	/**
	 * Given a JTable, this will attempt to set the column sizes appropriate to
	 * the table's contents.
	 */
	public static void SizeTblCols(JTable table) {
		TableModel model = table.getModel();
		TableColumn column = null;
		Component comp = null;

		TableCellRenderer headerRenderer = table.getTableHeader()
				.getDefaultRenderer();
		if (headerRenderer == null) {
			System.err.println("WARNING: SizeTblCols: headerRenderer is null!");
			return;
		}
		for (int i = 0; i < model.getColumnCount(); i++) {
			column = table.getColumnModel().getColumn(i);
			if (column == null) {
				System.err.println("WARNING: SizeTblCols: column is null!");
				return;
			}
			if (table.getTableHeader() == null) {
				System.err.println("WARNING: SizeTblCols: header is null!");
				return;
			}

			comp = headerRenderer.getTableCellRendererComponent(null, column
					.getHeaderValue(), false, false, 0, 0);
			int cellWidth = comp.getPreferredSize().width;

			for (int j = 0; j < model.getRowCount(); j++) {
				comp = table.getDefaultRenderer(model.getColumnClass(i))
						.getTableCellRendererComponent(table,
								model.getValueAt(j, i), false, false, j, i);
				cellWidth = Math.max(comp.getPreferredSize().width, cellWidth);
			}
			column.setPreferredWidth(cellWidth);
		}
	}

	public TableHeaderNPE(String text, String delim) {
		super(new GridLayout(1, 0));
		_delim = delim;
		updateModel(text);
		// Create the scroll pane and add the table to it.
		JScrollPane scrollPane = new JScrollPane(_tbl);
		SizeTblCols(_tbl);
		// Add the scroll pane to this panel.
		add(scrollPane);
	}

	public void updateModel(String src) {
		_src = src;
		BufferedReader br = new BufferedReader(new StringReader(_src));
		try {
			int numrows = 0;
			String line = br.readLine();
			String[] headers = line.split(_delim);

			Vector<String> colNames = new Vector<String>();
			for (String s : headers) {
				colNames.add(s);
			}
			line = br.readLine();
			Vector<Vector<String>> rows = new Vector<Vector<String>>();
			while (line != null && line.length() > 1) {
				String[] row = line.split(_delim);
				Vector<String> rowv = new Vector<String>();
				for (String s : row) {
					rowv.add(s);
				}
				rows.add(rowv);
				line = br.readLine();
				numrows++;
			}
			if (_tbl == null) {
				_tbl = new JTable();
			}
			DefaultTableModel mdl = new DefaultTableModel(rows, colNames);
			_tbl.setModel(mdl);
			SizeTblCols(_tbl);

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	JTable _tbl;
	String _delim;
	String _src;

	final static String _Data = "foobar\tyadda\tdoowop\n1\t2\t3\n";

	public static void main(String[] args) throws Exception {
		// if you comment these first two lines we're ok...
		SubstanceLookAndFeel substancelf = new SubstanceLookAndFeel();
		UIManager.setLookAndFeel(substancelf);
		//UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				JFrame f = new JFrame("SubTest");
				TableHeaderNPE st = new TableHeaderNPE(_Data, "\t");
				f.setContentPane(st);
				f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
				f.pack();
				f.setVisible(true);
			}
		});
	}
}