/*
 * Copyright (c) 2005-2007 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package test.samples.substance.clientprop;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.AlphaControlBackgroundComposite;

/**
 * Test application that shows the use of the
 * {@link SubstanceLookAndFeel#BACKGROUND_COMPOSITE} client property.
 * 
 * @author Kirill Grouchnikov
 * @see SubstanceLookAndFeel#BACKGROUND_COMPOSITE
 */
public class BackgroundComposite extends JFrame {
	/**
	 * Creates the main frame for <code>this</code> sample.
	 */
	public BackgroundComposite() {
		super("Background composite");

		this.setLayout(new BorderLayout());

		// Create panel with custom painting logic - simple
		// diagonal fill.
		JPanel samplePanel = new JPanel() {
			@Override
			protected void paintComponent(Graphics g) {
				Graphics2D graphics = (Graphics2D) g.create();
				graphics
						.setPaint(new GradientPaint(0, 0, new Color(100, 100,
								255), getWidth(), getHeight(), new Color(255,
								100, 100)));
				graphics.fillRect(0, 0, getWidth(), getHeight());
				graphics.dispose();
			}
		};
		samplePanel.setPreferredSize(new Dimension(800, 400));
		samplePanel.setSize(this.getPreferredSize());
		samplePanel.setMinimumSize(this.getPreferredSize());

		final JScrollPane scrollPane = new JScrollPane(samplePanel);

		this.add(scrollPane, BorderLayout.CENTER);

		JPanel controls = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		JButton set30_50_Composite = new JButton("Set 30-50");
		set30_50_Composite.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						scrollPane
								.putClientProperty(
										SubstanceLookAndFeel.BACKGROUND_COMPOSITE,
										new AlphaControlBackgroundComposite(
												0.3f, 0.5f));
						repaint();
					}
				});
			}
		});
		controls.add(set30_50_Composite);

		JButton set50_70_Composite = new JButton("Set 50-70");
		set50_70_Composite.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						scrollPane
								.putClientProperty(
										SubstanceLookAndFeel.BACKGROUND_COMPOSITE,
										new AlphaControlBackgroundComposite(
												0.5f, 0.5f));
						repaint();
					}
				});
			}
		});
		controls.add(set50_70_Composite);
		JButton set50_100_Composite = new JButton("Set 50-100");
		set50_100_Composite.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						scrollPane.putClientProperty(
								SubstanceLookAndFeel.BACKGROUND_COMPOSITE,
								new AlphaControlBackgroundComposite(0.5f));
						repaint();
					}
				});
			}
		});
		controls.add(set50_100_Composite);
		JButton set70_70_Composite = new JButton("Set 70-70");
		set70_70_Composite.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						scrollPane
								.putClientProperty(
										SubstanceLookAndFeel.BACKGROUND_COMPOSITE,
										new AlphaControlBackgroundComposite(
												0.7f, 0.7f));
						repaint();
					}
				});
			}
		});
		controls.add(set70_70_Composite);

		final JCheckBox hasOverlay = new JCheckBox("has overlay");
		hasOverlay.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						scrollPane.putClientProperty(
								SubstanceLookAndFeel.OVERLAY_PROPERTY,
								hasOverlay.isSelected() ? Boolean.TRUE : null);
						repaint();
					}
				});
			}
		});
		controls.add(hasOverlay);

		this.add(controls, BorderLayout.SOUTH);

		this.setSize(400, 200);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	/**
	 * The main method for <code>this</code> sample. The arguments are
	 * ignored.
	 * 
	 * @param args
	 *            Ignored.
	 * @throws Exception
	 *             If some exception occured. Note that there is no special
	 *             treatment of exception conditions in <code>this</code>
	 *             sample code.
	 */
	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		JFrame.setDefaultLookAndFeelDecorated(true);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new BackgroundComposite().setVisible(true);
			}
		});
	}
}
