package tools.jitterbug;

import java.awt.*;
import java.awt.datatransfer.*;
import java.awt.dnd.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.InputStream;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.skin.BusinessSkin;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;

public class JitterbugEditor extends JFrame implements ClipboardOwner {
	private JColorSchemeComponent colorSchemeComp;
	private JHsvGraph hsvGraph;
	private JTextArea textArea;

	private static String INSTRUCTIONAL = "Define color scheme name and colors\nor drag a color scheme definition here";

	protected class JitterbugDropHandler extends DropTargetAdapter {
		@Override
		public void drop(DropTargetDropEvent dtde) {
			Transferable t = dtde.getTransferable();
			if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
				try {
					dtde.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
					java.util.List files = (java.util.List) t
							.getTransferData(DataFlavor.javaFileListFlavor);
					File f = (File) files.get(0);
					colorSchemeComp.setContent(f.toURI().toURL());
					dtde.dropComplete(true);
					return;
				} catch (Exception exc) {
					exc.printStackTrace();
				}
			}
			// if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
			// try {
			// dtde.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
			// String content = (String) t
			// .getTransferData(DataFlavor.stringFlavor);
			// colorSchemeComp.setContent(new ByteArrayInputStream(content
			// .getBytes()));
			// dtde.dropComplete(true);
			// return;
			// } catch (Exception exc) {
			// exc.printStackTrace();
			// }
			// }
		}

		@Override
		public void dragEnter(DropTargetDragEvent dtde) {
			for (DataFlavor df : dtde.getCurrentDataFlavors()) {
				Class<?> repClass = df.getDefaultRepresentationClass();
				boolean canDrop = InputStream.class.isAssignableFrom(repClass);
				if (canDrop) {
					dtde.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);
					return;
				}
			}
		}
	}

	public JitterbugEditor() {
		super("Jitterbug editor for Substance color schemes");

		FormLayout leftPanelLayout = new FormLayout("fill:pref",
				"fill:pref, fill:pref:grow, fill:pref, fill:pref");
		DefaultFormBuilder leftPanelBuilder = new DefaultFormBuilder(
				leftPanelLayout);

		colorSchemeComp = new JColorSchemeComponent();
		// colorSchemeComp.setContent(is);
		leftPanelBuilder.append(colorSchemeComp);

		this.hsvGraph = new JHsvGraph();
		this.hsvGraph.setDropTarget(new DropTarget(this,
				new JitterbugDropHandler()));
		leftPanelBuilder.append(this.hsvGraph);

		this.textArea = new JTextArea(INSTRUCTIONAL);
		this.textArea.setBorder(new EmptyBorder(0, 5, 0, 5));
		this.textArea.setEditable(false);
		this.textArea.setOpaque(false);
		if (this.colorSchemeComp.isDefined()) {
			this.textArea.setText(this.colorSchemeComp.getEncoded());
		}
		this.textArea.setRows(9);
		this.textArea.setDropTarget(new DropTarget(this,
				new JitterbugDropHandler()));

		leftPanelBuilder.append(this.textArea);

		JPanel clipboardPanel = new JPanel(new FlowLayout(FlowLayout.LEADING));
		JButton exportToClipboard = new JButton("copy to clipboard");
		exportToClipboard.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				Clipboard clipboard = Toolkit.getDefaultToolkit()
						.getSystemClipboard();
				clipboard.setContents(new StringSelection(textArea.getText()),
						JitterbugEditor.this);
			}
		});
		clipboardPanel.add(exportToClipboard);

		// JButton importFromClipboard = new JButton("paste from clipboard");
		// importFromClipboard.addActionListener(new ActionListener() {
		// @Override
		// public void actionPerformed(ActionEvent e) {
		// Clipboard clipboard = Toolkit.getDefaultToolkit()
		// .getSystemClipboard();
		// if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
		// try {
		// String content = (String) clipboard
		// .getData(DataFlavor.stringFlavor);
		// colorSchemeComp.setContent(new ByteArrayInputStream(
		// content.getBytes()));
		// } catch (Exception exc) {
		// }
		// }
		// }
		// });
		// clipboardPanel.add(importFromClipboard);

		leftPanelBuilder.append(clipboardPanel);

		this.add(leftPanelBuilder.getPanel(), BorderLayout.WEST);

		JPanel mainPanel = new JPanel(new BorderLayout());
		JImageComponent imageComp = new JImageComponent();
		imageComp.addPropertyChangeListener("selectedColor",
				new PropertyChangeListener() {
					@Override
					public void propertyChange(PropertyChangeEvent evt) {
						Color selectedImageColor = (Color) evt.getNewValue();
						JColorComponent selectedColorComp = colorSchemeComp
								.getSelectedColorComponent();
						if (selectedColorComp != null) {
							selectedColorComp.setColor(selectedImageColor);

						}
					}
				});

		mainPanel.add(imageComp, BorderLayout.CENTER);

		this.add(mainPanel, BorderLayout.CENTER);

		colorSchemeComp.addChangeListener(new ChangeListener() {
			@Override
			public void stateChanged(ChangeEvent e) {
				if (colorSchemeComp.isDefined()) {
					textArea.setText(colorSchemeComp.getEncoded());
					Color[] colors = new Color[] {
							colorSchemeComp.getUltraLightColor(),
							colorSchemeComp.getExtraLightColor(),
							colorSchemeComp.getLightColor(),
							colorSchemeComp.getMidColor(),
							colorSchemeComp.getDarkColor(),
							colorSchemeComp.getUltraDarkColor() };
					hsvGraph.setColors(colors);
				} else {
					textArea.setText(INSTRUCTIONAL);
					hsvGraph.setColors(null);
				}
			}
		});

		this.setSize(800, 700);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		this.setAlwaysOnTop(true);
	}

	@Override
	public void lostOwnership(Clipboard clipboard, Transferable contents) {
	}

	public static void main(String[] args) {
		SubstanceLookAndFeel.setSkin(new BusinessSkin());
		JDialog.setDefaultLookAndFeelDecorated(true);
		JFrame.setDefaultLookAndFeelDecorated(true);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new JitterbugEditor().setVisible(true);
			}
		});
	}

}
