/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;

public abstract class Sqlca {
    protected transient Connection connection_;
    SQLException exceptionThrownOnStoredProcInvocation_;
    boolean messageTextRetrievedContainsTokensOnly_ = true;
    protected int sqlCode_;
    private String sqlErrmc_;
    protected String[] sqlErrmcTokens_;
    protected String sqlErrp_;
    protected int[] sqlErrd_;
    protected char[] sqlWarn_;
    protected String sqlState_;
    protected byte[] sqlErrmcBytes_;
    protected byte[] sqlErrpBytes_;
    protected byte[] sqlWarnBytes_;
    protected byte[] sqlStateBytes_;
    protected int ccsid_;
    protected int sqlErrmcCcsid_;
    protected boolean containsSqlcax_ = true;
    protected long rowsetRowCount_;
    private static final String sqlErrmcDelimiter__ = ";";
    private boolean returnTokensOnlyInMessageText_ = false;
    private final transient Agent agent_;
    private String cachedMessage;

    protected Sqlca(Connection connection) {
        this.connection_ = connection;
        this.agent_ = this.connection_ != null ? this.connection_.agent_ : null;
    }

    void returnTokensOnlyInMessageText(boolean bl) {
        this.returnTokensOnlyInMessageText_ = bl;
    }

    public synchronized int getSqlCode() {
        return this.sqlCode_;
    }

    public synchronized String getSqlErrmc() {
        int n;
        if (this.sqlErrmc_ != null) {
            return this.sqlErrmc_;
        }
        if (this.sqlErrmcTokens_ == null) {
            this.getSqlErrmcTokens();
        }
        if (this.sqlErrmcTokens_ == null) {
            return null;
        }
        if (this.sqlErrmcTokens_.length == 0) {
            this.sqlErrmc_ = "";
            return this.sqlErrmc_;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.sqlErrmcTokens_.length - 1; ++n) {
            stringBuffer.append(this.sqlErrmcTokens_[n]);
            stringBuffer.append(sqlErrmcDelimiter__);
        }
        stringBuffer.append(this.sqlErrmcTokens_[n]);
        this.sqlErrmc_ = stringBuffer.toString();
        return this.sqlErrmc_;
    }

    public synchronized String[] getSqlErrmcTokens() {
        if (this.sqlErrmcTokens_ != null) {
            return this.sqlErrmcTokens_;
        }
        this.sqlErrmcTokens_ = this.processSqlErrmcTokens(this.sqlErrmcBytes_);
        return this.sqlErrmcTokens_;
    }

    public synchronized String getSqlErrp() {
        if (this.sqlErrp_ != null) {
            return this.sqlErrp_;
        }
        if (this.sqlErrpBytes_ == null) {
            return null;
        }
        try {
            this.sqlErrp_ = this.bytes2String(this.sqlErrpBytes_, 0, this.sqlErrpBytes_.length);
            return this.sqlErrp_;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public int[] getSqlErrd() {
        if (this.sqlErrd_ != null) {
            return this.sqlErrd_;
        }
        this.sqlErrd_ = new int[6];
        return this.sqlErrd_;
    }

    public synchronized char[] getSqlWarn() {
        if (this.sqlWarn_ != null) {
            return this.sqlWarn_;
        }
        try {
            this.sqlWarn_ = this.sqlWarnBytes_ == null ? new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '} : this.bytes2String(this.sqlWarnBytes_, 0, this.sqlWarnBytes_.length).toCharArray();
            return this.sqlWarn_;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.sqlWarn_ = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
            return this.sqlWarn_;
        }
    }

    public synchronized String getSqlState() {
        if (this.sqlState_ != null) {
            return this.sqlState_;
        }
        if (this.sqlStateBytes_ == null) {
            return null;
        }
        try {
            this.sqlState_ = this.bytes2String(this.sqlStateBytes_, 0, this.sqlStateBytes_.length);
            return this.sqlState_;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String getMessage() throws SqlException {
        if (this.cachedMessage != null) {
            return this.cachedMessage;
        }
        if (this.connection_ == null) return this.getUnformattedMessage();
        if (this.connection_.isClosedX() != false) return this.getUnformattedMessage();
        if (this.returnTokensOnlyInMessageText_) {
            return this.getUnformattedMessage();
        }
        var1_1 = null;
        var2_2 = this.connection_;
        synchronized (var2_2) {
            block14: {
                block12: {
                    block13: {
                        block11: {
                            try {
                                var1_1 = this.connection_.prepareMessageProc("call SYSIBM.SQLCAMESSAGE(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                var1_1.setIntX(1, this.getSqlCode());
                                var1_1.setShortX(2, (short)(this.getSqlErrmc() != null ? this.getSqlErrmc().length() : 0));
                                var1_1.setStringX(3, this.getSqlErrmc());
                                var1_1.setStringX(4, this.getSqlErrp());
                                var1_1.setIntX(5, this.getSqlErrd()[0]);
                                var1_1.setIntX(6, this.getSqlErrd()[1]);
                                var1_1.setIntX(7, this.getSqlErrd()[2]);
                                var1_1.setIntX(8, this.getSqlErrd()[3]);
                                var1_1.setIntX(9, this.getSqlErrd()[4]);
                                var1_1.setIntX(10, this.getSqlErrd()[5]);
                                var1_1.setStringX(11, new String(this.getSqlWarn()));
                                var1_1.setStringX(12, this.getSqlState());
                                var1_1.setStringX(13, null);
                                var1_1.setStringX(14, Locale.getDefault().toString());
                                var1_1.registerOutParameterX(14, 12);
                                var1_1.registerOutParameterX(15, -1);
                                var1_1.registerOutParameterX(16, 4);
                                var1_1.executeX();
                                if (var1_1.getIntX(16) == 0) {
                                    this.messageTextRetrievedContainsTokensOnly_ = false;
                                    this.cachedMessage = var3_3 = var1_1.getStringX(15);
                                    var4_5 = var3_3;
                                    var6_6 = null;
                                    if (var1_1 == null) return var4_5;
                                    break block11;
                                }
                                var3_4 = this.getUnformattedMessage();
                                break block12;
                            }
                            catch (Throwable var5_12) {
                                var6_8 = null;
                                if (var1_1 == null) throw var5_12;
                                try {
                                    var1_1.closeX();
                                    throw var5_12;
                                }
                                catch (SQLException var7_11) {
                                    throw var5_12;
                                }
                            }
                        }
                        ** try [egrp 2[TRYBLOCK] [3 : 318->325)] { 
lbl53:
                        // 1 sources

                        var1_1.closeX();
                        break block13;
lbl55:
                        // 1 sources

                        catch (SQLException var7_9) {
                            // empty catch block
                        }
                    }
                    return var4_5;
                }
                var6_7 = null;
                if (var1_1 == null) return var3_4;
                ** try [egrp 2[TRYBLOCK] [3 : 318->325)] { 
lbl63:
                // 1 sources

                var1_1.closeX();
                break block14;
lbl65:
                // 1 sources

                catch (SQLException var7_10) {
                    // empty catch block
                }
            }
            return var3_4;
        }
    }

    public synchronized String getJDBCMessage() {
        if (this.connection_ != null && this.connection_.retrieveMessageText_) {
            try {
                return this.getMessage();
            }
            catch (SqlException sqlException) {
                this.exceptionThrownOnStoredProcInvocation_ = sqlException;
                this.chainDeferredExceptionsToAgentOrAsConnectionWarnings(sqlException);
                return this.getUnformattedMessage();
            }
        }
        return this.getUnformattedMessage();
    }

    private String getUnformattedMessage() {
        return "DERBY SQL error: SQLCODE: " + this.getSqlCode() + ", SQLSTATE: " + this.getSqlState() + ", SQLERRMC: " + this.getSqlErrmc();
    }

    private void chainDeferredExceptionsToAgentOrAsConnectionWarnings(SqlException sqlException) {
        SqlException sqlException2 = sqlException;
        while (sqlException2 != null) {
            SqlWarning sqlWarning;
            SqlException sqlException3 = (SqlException)sqlException2.getNextException();
            if ((sqlException2 = sqlException2.copyAsUnchainedSQLException(this.agent_.logWriter_)).getErrorCode() == -440) {
                sqlWarning = new SqlWarning(this.agent_.logWriter_, " Unable to obtain message text from server. See chained exception. The stored procedure SYSIBM.SQLCAMESSAGE is not installed on server. Contact your DBA.");
                sqlWarning.setNextException(sqlException2);
                this.connection_.accumulate440WarningForMessageProcFailure(sqlWarning);
            } else if (sqlException2.getErrorCode() == -444) {
                sqlWarning = new SqlWarning(this.agent_.logWriter_, " Unable to obtain message text from server. See chained exception. The stored procedure SYSIBM.SQLCAMESSAGE cannot be accessed on the server. Contact your DBA.");
                sqlWarning.setNextException(sqlException2);
                this.connection_.accumulate444WarningForMessageProcFailure(sqlWarning);
            } else {
                this.agent_.accumulateDeferredException(sqlException2);
            }
            sqlException2 = sqlException3;
        }
    }

    public boolean includesSqlCode(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != this.getSqlCode()) continue;
            return true;
        }
        return false;
    }

    private String[] processSqlErrmcTokens(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        if (n == 0) {
            return new String[0];
        }
        try {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            LinkedList<String> linkedList = new LinkedList<String>();
            for (n2 = 0; n2 < n - 1; ++n2) {
                if (byArray[n2] != -1) {
                    byteArrayOutputStream.write(byArray[n2]);
                    continue;
                }
                linkedList.add(this.bytes2String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size()));
                byteArrayOutputStream.reset();
            }
            n2 = n - 1;
            if (byArray[n2] != -1) {
                byteArrayOutputStream.write(byArray[n2]);
                linkedList.add(this.bytes2String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size()));
            } else {
                if (n2 != 0) {
                    linkedList.add(this.bytes2String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size()));
                }
                linkedList.add("");
            }
            String[] stringArray = new String[linkedList.size()];
            Iterator iterator = linkedList.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                stringArray[n3] = (String)iterator.next();
                ++n3;
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private String bytes2String(byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        return new String(byArray, n, n2, "UTF8");
    }

    public int getUpdateCount() {
        if (this.sqlErrd_ == null) {
            return 0;
        }
        return this.sqlErrd_[2];
    }

    public long getRowCount() throws DisconnectException {
        return ((long)this.sqlErrd_[0] << 32) + (long)this.sqlErrd_[1];
    }

    public void setContainsSqlcax(boolean bl) {
        this.containsSqlcax_ = bl;
    }

    public boolean containsSqlcax() {
        return this.containsSqlcax_;
    }

    public void resetRowsetSqlca(Connection connection, int n, byte[] byArray, byte[] byArray2, int n2) {
        this.connection_ = connection;
        this.sqlCode_ = n;
        this.sqlStateBytes_ = byArray;
        this.sqlErrpBytes_ = byArray2;
        this.ccsid_ = n2;
    }

    public void setRowsetRowCount(long l) {
        this.rowsetRowCount_ = l;
    }

    public long getRowsetRowCount() {
        return this.rowsetRowCount_;
    }
}

