/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Canvas
extends Composite {
    Caret caret;

    Canvas() {
    }

    public Canvas(Composite composite, int n) {
        super(composite, n);
    }

    void clearArea(int n, int n2, int n3, int n4) {
        this.checkWidget();
        if (OS.IsWindowVisible(this.handle)) {
            return;
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
        int n5 = OS.GetDCEx(this.handle, 0, 26);
        this.drawBackground(n5, rECT);
        OS.ReleaseDC(this.handle, n5);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    void releaseWidget() {
        if (this.caret != null) {
            this.caret.releaseResources();
        }
        this.caret = null;
        super.releaseWidget();
    }

    public void scroll(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7;
        boolean bl2;
        this.checkWidget();
        this.forceResize();
        boolean bl3 = bl2 = this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.killFocus();
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, n3, n4, n3 + n5, n4 + n6);
        RECT rECT2 = new RECT();
        OS.GetClientRect(this.handle, rECT2);
        if (OS.IntersectRect(rECT2, rECT, rECT2)) {
            if (OS.IsWinCE) {
                OS.UpdateWindow(this.handle);
            } else {
                n7 = 384;
                OS.RedrawWindow(this.handle, null, 0, n7);
            }
        }
        n7 = n - n3;
        int n8 = n2 - n4;
        int n9 = 6;
        OS.ScrollWindowEx(this.handle, n7, n8, rECT, null, 0, null, n9);
        if (bl) {
            Control[] controlArray = this._getChildren();
            int n10 = 0;
            while (n10 < controlArray.length) {
                Control control = controlArray[n10];
                Rectangle rectangle = control.getBounds();
                if (Math.min(n3 + n5, rectangle.x + rectangle.width) >= Math.max(n3, rectangle.x) && Math.min(n4 + n6, rectangle.y + rectangle.height) >= Math.max(n4, rectangle.y)) {
                    control.setLocation(rectangle.x + n7, rectangle.y + n8);
                }
                ++n10;
            }
        }
        if (bl2) {
            this.caret.setFocus();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.isFocusControl()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    LRESULT WM_KILLFOCUS(int n, int n2) {
        LRESULT lRESULT = super.WM_KILLFOCUS(n, n2);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return lRESULT;
    }

    LRESULT WM_SETFOCUS(int n, int n2) {
        LRESULT lRESULT = super.WM_SETFOCUS(n, n2);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGED(int n, int n2) {
        boolean bl;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGED(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        boolean bl2 = bl = (this.style & 0x4000000) != 0 && this.caret != null && this.caret.isFocusCaret();
        if (bl) {
            this.caret.setFocus();
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(int n, int n2) {
        boolean bl;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        boolean bl2 = bl = (this.style & 0x4000000) != 0 && this.caret != null && this.caret.isFocusCaret();
        if (bl) {
            this.caret.killFocus();
        }
        return lRESULT;
    }
}

