-- `Topal': GPG/Pine integration
--
-- Copyright (C) 2001  Phillip J. Brooke
--
--     This program is free software; you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation; either version 2 of the License, or
--     (at your option) any later version.
--
--     This program is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with this program; if not, write to the Free Software
--     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

with Globals; use Globals;

package Keys is

   type Key_List is limited private;

   Key_Not_Found : exception;

   -- Add a key to the list....
   procedure Add_Key (Key  : in     UBS;
                      List : in out Key_List);

   -- Remove a key.  We then shuffle the array down.
   -- It will only remove the last key if there are multiple instances.
   procedure Remove_Key (Key  : in     UBS;
                         List : in out Key_List);

   -- Turn the list of keys to send into `-r <key>' string.
   function Processed_Recipient_List (List : in Key_List) return String;

   -- Get key fingerprint(s) for a key.  Add them.
   -- The name is a bit odd.  Really, they should be `Search_For_Keys' or similar.
   -- The `By_Fingerprint' bit refers to how the keys are recorded.
   procedure Add_Keys_By_Fingerprint (Key_In : in     UBS;
                                      List   : in out Key_List;
                                      Found  :    out Boolean);

   procedure Add_Keys_By_Fingerprint (Key_In : in     UBS;
                                      List   : in out Key_List);

   -- Add the secret keys to this keylist.
   procedure Add_Secret_Keys (Key_In : in     UBS;
                              List   : in out Key_List);

   -- List the keys and edit them as appropriate (include removing a key
   -- from that list, and adding one from the keyring.
   procedure List_Keys (List : in out Key_List);

   -- List the keys.  Either return with Aborted true, or
   -- The_Fingerprint set to the chosen fingerprint.
   procedure Select_Key_From_List (List            : in out Key_List;
                                   The_Fingerprint :    out UBS;
                                   Aborted         :    out Boolean);

   -- Use keylist.  Given a list of recipients, add the keys, returning a
   -- new key list.
   procedure Use_Keylist (Recipients : in     UBS_Array;
                          List       : in out Key_List);

   procedure Empty_Keylist (List : in out Key_List);

   function Count (List : in Key_List) return Natural;

private

   type Key_List is
      record
         KA    : UBS_Big_Array;
         Count : Natural;
      end record;

end Keys;
