#include <stdio.h>

#ifdef MEMDBG
#include "memdbg.h"
#endif

#include "treestruct.h"

typedef struct {
	treenode n;
	} holdnewnoded, *holdnewnode;

static int showerrors;

int readcomment(f, c)
FILE *f;
char *c;
{
	int ch;

	ch=getc(f);
	while(ch!=']' && ch!=EOF)
		if(ch=='[')
		{
			if(!readcomment(f, c))
				return(0);
		}
		else
		{
			add_char(c, ch);
			ch=getc(f);
		}
	if(ch==']')
		return(1);
	else
	{
		if(showerrors)
			fprintf(stderr, "No end to a comment.\n");
		return(0);
	}
}

list readcommentlist(f)
FILE *f;
{
	list tmp, h;
	char *c;
	int ch;

	tmp=newlist();
	if(tmp==NULL)
		return(NULL);
	
	do
	{
		/* prepare a new string */
		c=(char *)new_string();
		/* read the comment */
		if(!readcomment(f, c))
		{
			/* bad comment */
			/* free current list */
			startlist(tmp);
			while((h=listnext(tmp))!=NULL)
				free(h);
			freelist(tmp);
			free(c);
			return(NULL);
		}
		/* store comment in list */
		c=(char *)freeze_string(c);
		addnode(tmp, c);

		ch=treeskipspace(f);
	} while(ch=='[');

	ungetc(ch, f);
	return(tmp);
}

treenode readtreenode(f, p)
/* f is file */
FILE *f;
treenode p;
{
	int ch;
	treenode tmp, r;
	double dist;
	int specified;
	char *name=NULL;
	
	tmp=makenode(NULL);
	if(tmp==NULL)
		return(NULL);

	addsubtree(p, tmp, 0.0, 0);

	ch=treeskipspace(f);
	if(ch==EOF)
		return(NULL);
	if(ch=='[')
	{
		/* comments before the node */
		tmp->bn=readcommentlist(f);
		if(tmp==NULL)
		{
			removesubtree(p, tmp);
			freesubtree(tmp);
			return(NULL);
		}
		ch=treeskipspace(f);
	}
	if(ch=='(')
	{
		/* node list */
		do
		{
			if(readtreenode(f, tmp)==NULL)
			{
				removesubtree(p, tmp);
				freesubtree(tmp);
				return(NULL);
			}

			ch=treeskipspace(f);
		} while(ch==',');

		/* now ch must = ')' */
		ch=treeskipspace(f);

		if(ch=='[')
		{
			/* comments after the list */
			tmp->al=readcommentlist(f);
			if(tmp==NULL)
			{
				removesubtree(p, tmp);
				freesubtree(tmp);
				return(NULL);
			}
			ch=treeskipspace(f);
		}
	}
	if(ch!=')' && ch!=';' && ch!=':' && ch!=',')
	{
		/* node name present */
		ungetc(ch, f);
		name=(char *)treereadname(f);
		ch=treeskipspace(f);
		if(name==NULL)
		{
			if(showerrors)
				fprintf(stderr, "Bad format for name\n");
			removesubtree(p, tmp);
			freesubtree(tmp);
			return(NULL);
		}
		if(ch=='[')
		{
			/* comments after the name */
			tmp->an=readcommentlist(f);
			if(tmp==NULL)
			{
				removesubtree(p, tmp);
				freesubtree(tmp);
				return(NULL);
			}
			ch=treeskipspace(f);
		}

	}
	if(ch==':')
	{
		ch=treeskipspace(f);
		/* distance present */
		if(ch=='[')
		{
			/* comments before the distance */
			tmp->bd=readcommentlist(f);
			if(tmp==NULL)
			{
				removesubtree(p, tmp);
				freesubtree(tmp);
				return(NULL);
			}
			ch=treeskipspace(f);
		}
		ungetc(ch, f);
		if(fscanf(f, "%lf", &dist)!=1)
		{
			if(showerrors)
				fprintf(stderr, "Bad format for distance\n");
			removesubtree(p, tmp);
			freesubtree(tmp);
			return(NULL);
		}
		ch=treeskipspace(f);
		if(ch=='[')
		{
			/* comments after the distance */
			tmp->ad=readcommentlist(f);
			if(tmp==NULL)
			{
				removesubtree(p, tmp);
				freesubtree(tmp);
				return(NULL);
			}
			ch=treeskipspace(f);
		}
		specified=1;
	}
	else
		specified=0;
	ungetc(ch, f);

	tmp->name=name;

	if(specified)
		setparentdistance(tmp, dist);

	if(tinit!=NULL)
		(*tinit)(tmp, tr_node);
	return(tmp);
}

tree readrootedtree(f, showerrors)
FILE *f;
int showerrors;
{
	treenode tmp;
	tree t;
	double dst;
	int specified;
	int ch;

	t=maketree(NULL, 1);
	if(t==NULL)
		return(NULL);

	tmp=readtreenode(f, t);
	ch=fgetc(f);
	if(ch!=';')
	{
		freetree(t);
		return(NULL);
	}
	ch=treeskipspace(f);
	ungetc(ch, f);
	if(tmp==NULL)
	{
		freetree(t);
		return(NULL);
	}

	if(tinit!=NULL)
		(*tinit)(t, tr_tree);
	return(t);
}
