/* Call the function version of tth, called textohtml */
/* If a second command line argument exists it is the TeX file to read
 otherwise accept interactive input. Files longer than CHARLEN are truncated.*/
#define CHARLEN 5000
# include <stdio.h>
# include <string.h>
int main(int argc, char *argv[])
{
  extern int textohtml(char* , char* , int, char*, int);
  FILE *file;
  int result;
  char tex[CHARLEN]={0};
  char html[CHARLEN];
  char err[CHARLEN];
  extern int ttm_mathitalic;
  extern int ttm_debug;
  ttm_debug=1;
  ttm_mathitalic=0; /*Turn off math italic switch*/
  if(argc>1){ /* Read a filename from the second argument.*/
    if((file=fopen(argv[1],"r"))){
      fprintf(stderr,"File translated %s\n",argv[1]);
      while(fgets(tex,CHARLEN,file)){
	result=textohtml(tex,html,CHARLEN,err,CHARLEN);
	printf("%s",html);
	if(strlen(err))fprintf(stderr,"%s",err);
      }
    }else{
      fprintf(stderr,"Can't open file %s\n",argv[1]);
      return 1;
    }
  }else{ /* Interactive line by line testing.*/
    fprintf(stdout,"Type in some TeX\n");
    while(fgets(tex,CHARLEN,stdin)){
      result=textohtml(tex,html,CHARLEN,err,CHARLEN);
      printf("textohtml call number %d:\n%s\n%s",result,html,err);
    };
  }
  return 0;
}





