 /* The function interface to tth. 
    Convert a texstring into an htmlstring which has length hlen.
    Stop converting when the length of htmlstring is > hlen-200.
    So hlen must be >200! Returns the number of times it has been called.
  */

int textohtml(char* texstring, char* htmlstring, int hlen,
	      char* errstring, int elen)
{
  static int initialized=0;
  if(tth_mathitalic){  /* Make italic the default.*/
    strcpy(tth_font_open[0],"<i>");
    strcpy(tth_font_close[0],"</i>");
    TTH_CCPY(tth_fonto_def,tth_font_open[0]);
    TTH_CCPY(tth_fontc_def,tth_font_close[0]);  
  }
  tth_outstring=htmlstring; /*The string where we will output HTML*/
  *tth_outstring=0;
  tth_htmllen=hlen;
  tth_errstring=errstring; /*The string where we will output messages*/
  *tth_errstring=0;
  tth_errlen=elen;
  tth_num_lines=0;
  if(!initialized){
    /*yy_push_state(latexbuiltins); Uncomment to force always LaTeX.*/
    yy_push_state(builtins);
  }
  yy_scan_string(texstring);
  yylex();
  initialized++;
  return initialized;
}
