/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.ContextException;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.engine.Engine;
import org.webmacro.util.Named;

public abstract class Variable
implements Macro {
    protected static final Object PROPERTY_TYPE = null;
    protected static final Object LOCAL_TYPE = new Object();
    protected static final Object TOOL_TYPE = new Object();
    protected String _vname;
    protected Object[] _names;

    Variable(Object[] objectArray) {
        this._vname = Variable.makeName(objectArray).intern();
        this._names = objectArray;
    }

    static final String[] makePropertyNames(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = objectArray[n] instanceof Named ? ((Named)objectArray[n]).getName() : (String)objectArray[n];
            ++n;
        }
        return stringArray;
    }

    final String[] getPropertyNames() {
        return Variable.makePropertyNames(this._names);
    }

    public final Object evaluate(Context context) {
        try {
            Object object = this.getValue(context);
            if (object instanceof Macro) {
                object = ((Macro)object).evaluate(context);
            }
            return object;
        }
        catch (NullPointerException nullPointerException) {
            Engine.log.exception(nullPointerException);
            Engine.log.warning("Variable: " + this._vname + " does not exist");
            return "<!--\n unable to access variable " + this._vname + ": not found in " + context + "\n -->";
        }
        catch (Exception exception) {
            Engine.log.exception(exception);
            Engine.log.warning("Variable: " + this._vname + " does not exist");
            return "<!--\n unable to access variable " + this._vname + ": " + exception + " \n-->";
        }
    }

    public final void write(FastWriter fastWriter, Context context) throws ContextException, IOException {
        try {
            fastWriter.write(this.evaluate(context).toString());
        }
        catch (Exception exception) {
            Engine.log.exception(exception);
            Engine.log.warning("Variable: " + this._vname + " is undefined");
            fastWriter.write("<!--\n warning: attempt to write out undefined variable " + this._vname + ": " + exception + " \n-->");
        }
    }

    static final String makeName(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            if (n != 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(objectArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public abstract Object getValue(Context var1) throws ContextException;

    public abstract void setValue(Context var1, Object var2) throws ContextException;

    public abstract String toString();
}

