/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import org.gjt.mm.mysql.MysqlDefs;

public class Field {
    int length;
    String Name;
    String TableName;
    int sql_type = -1;
    int mysql_type = -1;
    short colFlag;
    int colDecimals;

    Field(String Table, String Name, int length, int mysql_type, short col_flag, int col_decimals) {
        this.TableName = new String(Table);
        this.Name = new String(Name);
        this.length = length;
        this.colFlag = col_flag;
        this.colDecimals = col_decimals;
        this.mysql_type = mysql_type;
        this.sql_type = MysqlDefs.mysqlToJavaType(mysql_type);
        boolean is_binary = this.isBinary();
        if (this.sql_type == -4 && !is_binary) {
            this.sql_type = -1;
        } else if (this.sql_type == -3 && !is_binary) {
            this.sql_type = 12;
        }
    }

    public Field(String Table, String Name, int jdbc_type, int length) {
        this.TableName = new String(Table);
        this.Name = new String(Name);
        this.length = length;
        this.sql_type = jdbc_type;
        this.colFlag = 0;
        this.colDecimals = 0;
    }

    public String getTable() {
        if (this.TableName != null) {
            return this.TableName;
        }
        return null;
    }

    public String getName() {
        if (this.Name != null) {
            return new String(this.Name);
        }
        return null;
    }

    public String getFullName() {
        String FullName = String.valueOf(this.TableName) + "." + this.Name;
        return FullName;
    }

    public String getTableName() {
        return this.TableName;
    }

    public int getLength() {
        return this.length;
    }

    public int getSQLType() {
        return this.sql_type;
    }

    public int getMysqlType() {
        return this.mysql_type;
    }

    int getDecimals() {
        return this.colDecimals;
    }

    boolean isNotNull() {
        return (this.colFlag & 1) > 0;
    }

    public boolean isPrimaryKey() {
        return (this.colFlag & 2) > 0;
    }

    public boolean isUniqueKey() {
        return (this.colFlag & 4) > 0;
    }

    public boolean isMultipleKey() {
        return (this.colFlag & 8) > 0;
    }

    public boolean isBlob() {
        return (this.colFlag & 0x10) > 0;
    }

    public boolean isUnsigned() {
        return (this.colFlag & 0x20) > 0;
    }

    public boolean isZeroFill() {
        return (this.colFlag & 0x40) > 0;
    }

    public boolean isBinary() {
        return (this.colFlag & 0x80) > 0;
    }

    public String toString() {
        return this.getFullName();
    }
}

