/*
 * Created on 25-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui;

import java.io.File;
import java.util.Iterator;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionContainer;
import org.herac.tuxguitar.gui.actions.dispose.DisposeAction;
import org.herac.tuxguitar.gui.editors.EditorCache;
import org.herac.tuxguitar.gui.editors.FretBoardEditor;
import org.herac.tuxguitar.gui.editors.PianoEditor;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.chord.CustomChordManager;
import org.herac.tuxguitar.gui.editors.lyric.LyricEditor;
import org.herac.tuxguitar.gui.helper.FileHistory;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.items.ItemManager;
import org.herac.tuxguitar.gui.mixer.SongMixer;
import org.herac.tuxguitar.gui.scale.MusicScaleManager;
import org.herac.tuxguitar.gui.system.config.ConfigKeys;
import org.herac.tuxguitar.gui.system.config.ConfigManager;
import org.herac.tuxguitar.gui.system.keybindings.KeyBindingManager;
import org.herac.tuxguitar.gui.system.language.LanguageManager;
import org.herac.tuxguitar.gui.system.plugins.PluginManager;
import org.herac.tuxguitar.gui.transport.SongTransport;
import org.herac.tuxguitar.gui.util.ArgumentParser;
import org.herac.tuxguitar.gui.util.ClassLoaderUtil;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.gui.util.SplashShell;
import org.herac.tuxguitar.gui.util.SystemError;
import org.herac.tuxguitar.gui.util.WindowTitleUtil;
import org.herac.tuxguitar.io.FileFormatFormatException;
import org.herac.tuxguitar.player.NullPlayer;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.song.managers.SongManager;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class TuxGuitar {
	public static final String TUXGUITAR_NAME = "TuxGuitar";
	
	public static final String TUXGUITAR_VERSION = "0.9";
	
	private static final String appConfigDomain = ".tuxguitar";
	
	private static final String appConfigDomainEnvVar = "TUXGUITAR_CONFIG_HOME";
	
	public static final int MARGIN_WIDTH = 5;
	
	private static TuxGuitar instance;

	private Display display;

	private Shell shell;

	private SongManager songManager;

	private MidiPlayer player;
	
	private LanguageManager languageManager;

	private ConfigManager configManager;
	
	private KeyBindingManager keyBindingManager;
	
	private Composite sashComposite;
	
	private Sash sash;

	private EditorCache editorCache;
	
	private TablatureEditor tablatureEditor;

	private SongTableViewer tableViewer;
	
	private SongMixer songMixer;
	
	private SongTransport songTransport;
	
	private FretBoardEditor fretBoardEditor;
	
	private PianoEditor pianoEditor;
	
	private LyricEditor lyricEditor;
	
	private MusicScaleManager scaleManager;
	
	private ActionContainer actionContainer;

	private ItemManager itemManager;

	private CustomChordManager customChordManager;
	
	private FileHistory fileHistory;

	private PluginManager pluginManager;
	
	public static void main(String[] args) {
		TuxGuitar.instance().displayGUI(args);
	}

	public TuxGuitar() {
	}

	public static TuxGuitar instance() {
		if (instance == null) {
			synchronized (TuxGuitar.class) {
				instance = new TuxGuitar();
			}
		}
		return instance;
	}
	
	private void initLanguage() {
		this.languageManager = new LanguageManager();
		this.languageManager.setLanguage(getConfig().getStringConfigValue(ConfigKeys.LANGUAGE));
	}

	public void displayGUI(String[] args) {		
		//checkeo los argumentos
		ArgumentParser argumentParser = new ArgumentParser(args);
		if(argumentParser.printAndExit()){
			return;
		}		
	    this.initConfigManager();
		this.initLanguage();
		this.display = new Display();

		SplashShell splash = new SplashShell(display);

		this.shell = new Shell(display);		
		this.shell.setLayout(getShellLayout());		
		this.shell.setImage(SystemImages.TUXGUITAR_ICON);

		this.songManager = new SongManager();
		this.initPluginManager();
		if(argumentParser.getFile() != null){
			try {
				this.songManager.open(argumentParser.getFile().getPath());
			}catch (FileFormatFormatException e) {				
				e.printStackTrace();
				this.songManager.newSong();
			}
		}
		this.initPlayer(false);
		this.fileHistory = new FileHistory();
		this.editorCache = new EditorCache();
		this.scaleManager = new MusicScaleManager();		
		this.tablatureEditor = new TablatureEditor(this.songManager);
		this.tableViewer = new SongTableViewer(this.tablatureEditor);
		this.fretBoardEditor = new FretBoardEditor(this.tablatureEditor);
		this.pianoEditor = new PianoEditor(this.tablatureEditor);
		this.songMixer = new SongMixer();
		this.songTransport = new SongTransport();
		this.customChordManager = new CustomChordManager();
		this.lyricEditor = new LyricEditor();
		
		this.initActions();
		this.adjustKeyBindings();		
		this.initItems();		
		this.createComposites(shell);

		boolean maximized = getConfig().getBooleanConfigValue(ConfigKeys.MAXIMIZED);
		this.shell.setMaximized(maximized);
		if(!maximized){
			int width = getConfig().getIntConfigValue(ConfigKeys.WIDTH); 
			int height = getConfig().getIntConfigValue(ConfigKeys.HEIGHT);
			if(width > 0 && height > 0){
				this.shell.setSize(width,height);
			}
		}
		this.tablatureEditor.getTablature().setFocus();
		
		this.shell.setMinimumSize(640,480);		
		
		this.showDefaultControls();
		this.updateCache(true);
		this.showTitle();
				
		splash.close();
		this.shell.addDisposeListener(getAction(DisposeAction.NAME));
		this.shell.open();		
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		getDisplay().dispose();
		System.exit(0);
	}

	private FormLayout getShellLayout(){
		FormLayout layout = new FormLayout();
		layout.marginWidth = MARGIN_WIDTH;
		layout.marginHeight = MARGIN_WIDTH;
		return layout;
	}
	
	public void createComposites(Composite composite) {
		this.sashComposite = new Composite(composite,SWT.NONE);
		this.sashComposite.setLayout(new FormLayout());
		FormData data = new FormData();
		data.left = new FormAttachment(0,0); 
		data.right = new FormAttachment(100,0); 
		data.top = new FormAttachment(this.itemManager.getCoolbar(),MARGIN_WIDTH);
		data.bottom = new FormAttachment(100,0);
		sashComposite.setLayoutData(data);
				
		this.sash = new Sash(sashComposite, SWT.HORIZONTAL | SWT.SEPARATOR);
	    data = new FormData();
		data.left = new FormAttachment(0,0);
		data.right = new FormAttachment(100,0);
		data.top = new FormAttachment(75,0);		
		sash.setLayoutData(data);
	    
	    this.tablatureEditor.showTablature(sashComposite); 
	    data = new FormData();
		data.left = new FormAttachment(0,0);
		data.right = new FormAttachment(100,0);
		data.top = new FormAttachment(0,0);
		data.bottom = new FormAttachment(sash, 0);
		this.tablatureEditor.getTablature().setLayoutData(data);	    
	    	    
	    this.tableViewer.showTable(sashComposite);
	    data = new FormData();
		data.left = new FormAttachment(0,0);
		data.right = new FormAttachment(100,0);
		data.top = new FormAttachment(sash,10);
		data.bottom = new FormAttachment(100,0);
		this.tableViewer.getTableInfo().setLayoutData(data);		  
	    	    
	    sash.addSelectionListener(new SelectionAdapter() {
	        public void widgetSelected(SelectionEvent event) {	            
	            int sashNumerator = (event.y * 100 / sashComposite.getBounds().height);
	            sashNumerator = Math.max(sashNumerator,0);
	            sashNumerator = Math.min(sashNumerator,100);	            
	            ((FormData) sash.getLayoutData()).top = new FormAttachment(sashNumerator,0);
	        }
	      });
	    sash.addMouseListener(new MouseAdapter() {
            public void mouseUp(MouseEvent e) {
                sash.getParent().layout();
            }
        });
	    	    	    
		data = new FormData();
		data.left = new FormAttachment(0,0);
		data.right = new FormAttachment(100,0);
		data.top = new FormAttachment(sashComposite,0);
		data.bottom = new FormAttachment(100,0);
		
		Composite footer = new Composite(composite,SWT.NONE);
		footer.setLayout(new FormLayout());
		footer.setLayoutData(data);		
	    this.fretBoardEditor.showFretBoard(footer);
	}
	
	public void checkSoundbank(){
		boolean customSoundbank = getConfig().getBooleanConfigValue(ConfigKeys.SOUNDBANK_CUSTOM);
		if(customSoundbank){
			if(!getPlayer().loadSoundbank(new File(getConfig().getStringConfigValue(ConfigKeys.SOUNDBANK_CUSTOM_PATH)))){
	    		String title = TuxGuitar.getProperty("soundbank.error");    	
	    		String message = TuxGuitar.getProperty("soundbank.error.custom");
	    		new MessageDialog(title,message,SWT.ICON_ERROR | SWT.OK).show(shell);
			}
		}
	}
	
	public void initPlayer(boolean forceDefault){		
		if(getPlayer() == null || forceDefault){
			MidiPlayer player = null;
			Object object = ClassLoaderUtil.newInstance(getConfig().getStringConfigValue(ConfigKeys.SYSTEM_PLAYER));
			if(object instanceof MidiPlayer){
				player = (MidiPlayer)object;
			}
			if(player == null){
				player = new NullPlayer();
			}
			initPlayer(player);
		}
	}
	
	public void initPlayer(MidiPlayer player){		
		if(this.player != null){
			this.player.close();
		}
		this.player = player;		
		Iterator it = player.getSystemErrors().iterator();
		while(it.hasNext()){
			SystemError error = (SystemError)it.next();
			new MessageDialog(error.getTitle(),error.getMessage(),SWT.ICON_ERROR | SWT.OK).show(shell);
		}		
	}
	
	public void showDefaultControls(){	    	    
		//---Fretboard---
	    if(getConfig().getBooleanConfigValue(ConfigKeys.SHOW_FRETBOARD)){
	    	getFretBoardEditor().showFretBoard();
	    }else{
	    	getFretBoardEditor().hideFretBoard();	    	
	    }
	    
	    //---Mixer---
		if(getConfig().getBooleanConfigValue(ConfigKeys.SHOW_MIXER)){
			new SyncThread(new Runnable() {			
				public void run() {
					getMixer().show();
				}			
			}).start();
			
		}else{
			getMixer().dispose();
		}
		
	    //---Transport---		
		if(getConfig().getBooleanConfigValue(ConfigKeys.SHOW_TRANSPORT)){
			new SyncThread(new Runnable() {			
				public void run() {
					getTransport().show();
				}			
			}).start();						
		}else{
			getTransport().dispose();
		}

	    //---Piano---
		if(getConfig().getBooleanConfigValue(ConfigKeys.SHOW_PIANO)){
			new SyncThread(new Runnable() {			
				public void run() {
					getPianoEditor().show();
				}			
			}).start();						
		}else{
			getPianoEditor().dispose();
		}
	}
	
	public void updateShellFooter(int offset,int minimunWith,int minimunHeight){
		minimunWith = Math.max(640,minimunWith);
		minimunHeight = Math.max(480,minimunHeight);
		
	    FormData data = ((FormData)this.sashComposite.getLayoutData());
	    data.bottom.offset = -offset;
	    shell.setMinimumSize(minimunWith,minimunHeight);
	    shell.layout();
	}	

	public TablatureEditor getTablatureEditor(){
	    return this.tablatureEditor;
	}
	
	public FretBoardEditor getFretBoardEditor(){
		return this.fretBoardEditor;
	}		

	public PianoEditor getPianoEditor(){
		return this.pianoEditor;
	}		
	
	private void initItems() {		
		this.itemManager = new ItemManager(this.tablatureEditor);
		this.itemManager.createItems(this.shell);
	}

	private void initActions() {
		this.actionContainer = new ActionContainer(this.tablatureEditor);
		this.actionContainer.initActions();
	}
	
	private void initConfigManager(){
		this.configManager = new ConfigManager();	
		this.configManager.init();
	}

	
	private void adjustKeyBindings() {
		this.keyBindingManager = new KeyBindingManager();
		this.keyBindingManager.init();
	}
	
	private void initPluginManager(){
		this.pluginManager = new PluginManager();	
		this.pluginManager.loadPlugins();
		this.pluginManager.initPLugins();
	}
	
	public SongManager getSongManager(){
		return this.songManager;
	}
	
	public SongMixer getMixer(){
		return this.songMixer;
	}
	
	public SongTransport getTransport(){
		return this.songTransport;
	}	
	
	public SongTableViewer getTableViewer(){
		return this.tableViewer;
	}
	
	public EditorCache getEditorCache(){
		return this.editorCache;
	}
	
	public LyricEditor getLyricEditor(){
		return this.lyricEditor;
	}
	
	
	public MusicScaleManager getScaleManager(){
		return this.scaleManager;
	}
	
	public PluginManager getPluginManager(){
		return this.pluginManager;
	}
	
	public CustomChordManager getCustomChordManager(){
		return this.customChordManager;
	}
	
	public MidiPlayer getPlayer(){
		return this.player;
	}
	
	public void showTitle(){
		getShell().setText(WindowTitleUtil.parseTitle());
	}
	
	public void updateCache(boolean updateItems){
		getEditorCache().updateCaretMode();			
		if(updateItems){
			getItemManager().updateItems();
			getTransport().updateItems();
			getLyricEditor().updateSongTrack();
		}
	}
		


	
	
	public void redraw(){
	    if(!getDisplay().isDisposed()){	    	
	    	this.tablatureEditor.getTablature().redraw();	    	
	        this.fretBoardEditor.redraw();
	        this.pianoEditor.redraw();
	        this.tableViewer.getTableInfo().redraw();	        
	    }
	}
	
	public void redrawPayingMode(){
	    if(!getDisplay().isDisposed()){
	    	this.editorCache.updatePlayingMode();
	    	if(editorCache.shouldRedraw()){
	    		this.tablatureEditor.getTablature().redrawPlayingMode();
	    		this.fretBoardEditor.redrawPlayingMode();
	    		this.pianoEditor.redrawPlayingMode();
	    		this.tableViewer.getTableInfo().redrawPlayingMode();
	    		this.songTransport.redraw();
	    	}
	    }
	}
	
	public void fireUpdate(){
		this.editorCache.reset();
		this.tablatureEditor.getTablature().updateTablature();
		this.tableViewer.getTableInfo().fireUpdate();
	}
	

	
	public Display getDisplay(){
	    return this.display;
	}
	
	public Shell getShell(){
	    return this.shell;
	}
	
	public Action getAction(String name) {
		return this.actionContainer.getAction(name);
	}

	public ItemManager getItemManager() {
		return itemManager;
	}

	public ActionContainer getActionContainer() {
		return this.actionContainer;
	}

	public LanguageManager getLanguageManager() {
		return this.languageManager;
	}

	public static String getProperty(String key) {
		return TuxGuitar.instance().languageManager.getProperty(key);
	}
   
	public ConfigManager getConfig(){
	    return this.configManager;
	}

	public KeyBindingManager getkeyBindingManager(){
		return this.keyBindingManager;
	}

	public FileHistory getFileHistory(){
		return this.fileHistory;
	}
	
	public static boolean isDisposed(){
	    return TuxGuitar.instance().getDisplay().isDisposed();
	}
	
    public void showErrorMessage(final Throwable throwable){
        new SyncThread(new Runnable() {
            public void run() {
		    	throwable.printStackTrace();
		    	String title = getProperty("error");
		    	String message = throwable.toString();
		    	new MessageDialog(title,message,SWT.ICON_ERROR).show(shell);
            }
        }).start();    	    	
    }
        
	public void loadLanguage(){
		getLanguageManager().setLanguage(getConfig().getStringConfigValue(ConfigKeys.LANGUAGE));		
	}

	public void loadProperties(){
		getItemManager().loadProperties();         
		getTableViewer().getTableInfo().loadProperties();
	    getFretBoardEditor().loadProperties();
	    getPianoEditor().loadProperties();
	    getMixer().loadProperties();
	    getTransport().loadProperties();		
	}
	
	public void loadToolBars(){
		getItemManager().makeCoolItems();
	}	

	public void loadStyles(){
		getTablatureEditor().getTablature().reloadStyles();
	}
	    

}