/*
 * Created on 09-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.clipboard;

import java.util.Iterator;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableInsertMeasure;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableReplaceMeasures;
import org.herac.tuxguitar.song.helpers.TracksMeasures;
import org.herac.tuxguitar.song.models.MeasureHeader;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class MeasureTransferable implements Transferable {
	public static final int TRANSFER_TYPE_REPLACE = 1;
	public static final int TRANSFER_TYPE_INSERT = 2;
	
    private TablatureEditor tablatureEditor;
    private TracksMeasures tracksMeasures;
    private long p1;
    private long p2;
    private int transferType;

    public MeasureTransferable(TablatureEditor tablatureEditor, long p1, long p2,boolean allTracks) {
        this.tablatureEditor = tablatureEditor;
        this.transferType = TRANSFER_TYPE_REPLACE;
        this.p1 = p1;
        this.p2 = p2;        
        this.getTransfer(p1, p2,allTracks);
    }

    private void getTransfer(long p1, long p2,boolean allTracks) {
    	if(allTracks){
    		this.tracksMeasures = TuxGuitar.instance().getSongManager().copyMeasures(p1,p2);
    	}else{
    		SongTrackCoords trackCoords = tablatureEditor.getTablature().getCaret().getSongTrackCoords();
    		this.tracksMeasures = TuxGuitar.instance().getSongManager().copyMeasures(p1,p2,trackCoords.getTrack());
    	}
    	skipMarkers();
    }
    
    public void insertTransfer() throws CannotInsertTransferException {
        if(this.transferType == TRANSFER_TYPE_REPLACE){
        	replaceMeasures();
        }else if(this.transferType == TRANSFER_TYPE_INSERT){
        	insertMeasures();
        }
    }
    
    public void insertMeasures() throws CannotInsertTransferException {
        MeasureCoords measureCoords = tablatureEditor.getTablature().getCaret().getMeasureCoords();
        SongCoords songCoords = tablatureEditor.getTablature().getCaret().getSongCoords();
        if (measureCoords == null || songCoords == null || this.tracksMeasures.isEmpty()) {
            throw new CannotInsertTransferException();
        }
        //comienza el undoable
        UndoableInsertMeasure undoable = new UndoableInsertMeasure();
        
        int fromNumber = measureCoords.getMeasure().getNumber();
        long theMove = (measureCoords.getMeasure().getStart() - p1);       

        TuxGuitar.instance().getSongManager().insertMeasures((TracksMeasures)this.tracksMeasures.clone(),fromNumber,theMove);
        
        //termia el undoable
        tablatureEditor.getUndoManager().addEdit(undoable.endUndo((TracksMeasures)this.tracksMeasures.clone(),this.tracksMeasures.getMeasureHeaders().size(),fromNumber,theMove));          
    }    

    
    
    public void replaceMeasures() throws CannotInsertTransferException {        
        MeasureCoords measureCoords = tablatureEditor.getTablature().getCaret().getMeasureCoords();
        SongTrackCoords trackCoords = tablatureEditor.getTablature().getCaret().getSongTrackCoords();
        SongCoords songCoords = tablatureEditor.getTablature().getCaret().getSongCoords();
        if (measureCoords == null || songCoords == null || this.tracksMeasures.isEmpty()) {
            throw new CannotInsertTransferException();
        }
        
        //si no existen los compases los creo        
        int count = this.tracksMeasures.getMeasureHeaders().size();
        int current = measureCoords.getMeasure().getNumber();
        int freeSpace =  (trackCoords.getMeasuresCoords().size()  - (current - 1));
        long theMove = (measureCoords.getMeasure().getStart() - p1);
               
        //comienza el undoable
    	UndoableReplaceMeasures undoable = new UndoableReplaceMeasures(p1 + theMove,p2 + theMove);          
        
        for(int i = freeSpace;i < count;i ++){
        	tablatureEditor.getSongManager().addNewMeasureBeforeEnd();
        }           
        tablatureEditor.getSongManager().replaceMeasures((TracksMeasures)this.tracksMeasures.clone(),theMove);
        
        //Termina el undoable
        tablatureEditor.getUndoManager().addEdit(undoable.endUndo((TracksMeasures)this.tracksMeasures.clone(),count,freeSpace,theMove));
    }        
    
    public void setTransferType(int transferType){
    	this.transferType = transferType;
    }

    private void skipMarkers(){
    	Iterator it = this.tracksMeasures.getMeasureHeaders().iterator();
    	while(it.hasNext()){
    		MeasureHeader header = (MeasureHeader)it.next();
    		header.setMarker(null);
    	}
    }
}