package org.herac.tuxguitar.gui.editors.chord.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.herac.tuxguitar.song.models.Chord;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ChordReader {
	private static final String ACTION_ATTRIBUTE = "action";
	private static final String KEYS_ATTRIBUTE = "keys";
	
	private static final String CHORD_LIST_TAG = "chords";
	private static final String CHORD_TAG = "chord";
	private static final String CHORD_NAME_ATTRIBUTE = "name";
	private static final String CHORD_STRINGS_ATTRIBUTE = "strings";
	private static final String STRING_TAG = "string";
	private static final String STRING_NUMBER_ATTRIBUTE = "number";
	private static final String STRING_FRET_ATTRIBUTE = "fret";
	
    public static List getChords(String fileName) {
    	List chords = new ArrayList();
    	try{
    		File file = new File(fileName);        
        	if (file.exists()){
        		Document doc = getDocument(file);
        		loadChords(doc.getFirstChild(),chords);
        	}
    	}catch(Exception e){
    		e.printStackTrace();
    	}        
        return chords;
    }
    
    private static Document getDocument(File file) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(file);
        } catch (SAXException sxe) {
            sxe.printStackTrace();
        } catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return document;
    }

    /**
     * Read shortcuts from xml file
     * 
     * @param shortcutsNode
     * @return
     */
    private static void loadChords(Node chordsNode,List chords){
    	try{
    		NodeList chordList = chordsNode.getChildNodes();
    		for (int i = 0; i < chordList.getLength(); i++) {
    			Node chordItem = chordList.item(i);
    			if (chordItem.getNodeName().equals(CHORD_TAG)) {
    				NamedNodeMap chordAttributes = chordItem.getAttributes();

    				String name = chordAttributes.getNamedItem(CHORD_NAME_ATTRIBUTE).getNodeValue();
    				String strings = chordAttributes.getNamedItem(CHORD_STRINGS_ATTRIBUTE).getNodeValue();
            	
    				Chord chord = new Chord(Integer.parseInt(strings));
    				chord.setName(name);
            	
    				NodeList stringList = chordItem.getChildNodes();
    				for (int j = 0; j < stringList.getLength(); j++) {
    					Node stringItem = stringList.item(j);                
    					if (stringItem.getNodeName().equals(STRING_TAG)) {
    						NamedNodeMap stringAttributes = stringItem.getAttributes();
                		
    						String number = stringAttributes.getNamedItem(STRING_NUMBER_ATTRIBUTE).getNodeValue();
    						String fret = stringAttributes.getNamedItem(STRING_FRET_ATTRIBUTE).getNodeValue();
                		
    						chord.addFretValue(Integer.parseInt(number),Integer.parseInt(fret));
    					}	
    				}
    				chords.add(chord);
    			}

    		}
    	}catch(Exception e){
    		chords.clear();
    		e.printStackTrace();
    	}
    }
}
