package org.herac.tuxguitar.gui.editors.lyric;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.helper.SyncThread;

public class LyricModifyListener implements ModifyListener,Runnable{

	private LyricEditor editor;
	
	public LyricModifyListener(LyricEditor editor){
		this.editor = editor;
	}
	
	public void modifyText(ModifyEvent e) {
		if(e.widget instanceof Text){		
			this.editor.getTrack().getLyrics().setLyrics(((Text)e.widget).getText());
		}else if(e.widget instanceof Spinner){
			this.editor.getTrack().getLyrics().setFrom(((Spinner)e.widget).getSelection());
		}
		
		if(!TuxGuitar.isDisposed()){
			new SyncThread(this).start();        	
		}
	}

	public void run() {		
		TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().updateLyrics();
		TuxGuitar.instance().redraw();	
	}
	
}
