package org.herac.tuxguitar.gui.editors.tab;

import org.eclipse.swt.graphics.GC;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;

public class LyricPainter {
	private SongTrackCoords trackCoords;
	private String[] lyricBeats;    	
	private int from;	
	private int height;
	int nextIndex = 0;
	
	public LyricPainter(SongTrackCoords trackCoords){
		this.trackCoords = trackCoords;
		this.update();
	}
	
	public void update(){
		this.lyricBeats = trackCoords.getTrack().getLyrics().getLyricBeats();
		this.from = trackCoords.getTrack().getLyrics().getFrom();
		this.height = 0;
		if(this.lyricBeats != null && this.lyricBeats.length > 0){
			this.height = 10;
		}
	}
	   
	public void start(){
		this.start(0);
	}

	public void start(int index){
		this.nextIndex = index;
	}


	public void setCurrentMeasure(MeasureCoords measure){
		if(measure.getMeasure().getNumber() >= from){
			measure.setLyricBeatIndex(nextIndex);
			this.nextIndex += measure.getBeatPositions().size();
		}else{
			measure.setLyricBeatIndex(-1);
			this.start();
		}
	}

	public void paintCurrentNoteBeats(GC gc,ViewLayout layout,MeasureCoords currentMeasure ,int fromX,int fromY){
		int beatIndex = currentMeasure.getLyricBeatIndex();
		if(this.lyricBeats != null && beatIndex >= 0 && beatIndex < this.lyricBeats.length){
			for(int i = 0;i < currentMeasure.getBeatPositions().size();i ++){
				MeasureCoords.BeatPosition noteBeat = (MeasureCoords.BeatPosition)currentMeasure.getBeatPositions().get(i);
			
				if((beatIndex + i) < this.lyricBeats.length){
					String str = lyricBeats[beatIndex + i];
					if(str.trim().length() > 0){
						int x = fromX + noteBeat.getPosX();
					
						layout.setLyricStyle(gc);
						if(layout.isPlayModeEnabled() && noteBeat.isPlayingBeat()){
				        	layout.setPlayNoteColor(gc);
				        }				        					        
						
						gc.drawString(str,x + 13,(fromY + currentMeasure.getTs().getPosition(TrackSpacing.POSITION_LYRIC)));
						layout.setTabNoteColor(gc);
					}			
				}
			}		
		}
	}

	public int getHeight(){
		return height;
	}
}

