/*
 * Created on 29-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SongTrackCoords {           
    private Tablature tablature;
    private SongManager songManager;
    private SongTrack track;
    private List measuresCoords;
    private LyricPainter lyricPainter;
    
    private int tabHeight;
    private int scoreHeight;
    
    public SongTrackCoords(Tablature tablature,SongManager songManager,SongTrack track,ViewLayout layout) {
        this.tablature = tablature;
        this.track = track;
        this.songManager = songManager;
        this.measuresCoords = new ArrayList();
        this.lyricPainter = new LyricPainter(this);
        this.calculateTabHeight(layout);
        this.calculateScoreHeight(layout);
    }
    
    
    /**
     * Calcula el el ancho de la tablatura
     */
    public void calculateTabHeight(ViewLayout layout) {
    	this.tabHeight = ((layout.isTablatureEnabled())?((getTrack().stringCount() - 1) * layout.getStringSpan()):0);
    }
    
    /**
     * Calcula el el ancho de la partitura
     */
    public void calculateScoreHeight(ViewLayout layout) {
    	this.scoreHeight = ((layout.isScoreEnabled())?(layout.getScoreLineSpan() * 5):0);
    }
    
    public List getMeasuresCoords(){
        return this.measuresCoords;
    }
    
    public SongTrack getTrack(){
        return this.track;
    }
    
    public MeasureCoords getFirstMeasure(){
        MeasureCoords firstMeasure = null;    
        for(int measureIdx = 0;measureIdx < measuresCoords.size();measureIdx++){
            MeasureCoords currMeasure = (MeasureCoords)measuresCoords.get(measureIdx);
            if(firstMeasure == null || (currMeasure.getMeasure().getStart() < firstMeasure.getMeasure().getStart())){
                firstMeasure = currMeasure;
            }
        }        
        return firstMeasure;
    }     

    public MeasureCoords getLastMeasure(){
        int lastIndex = this.measuresCoords.size() - 1; 
        return (MeasureCoords)measuresCoords.get(lastIndex);
    }      
    
    public MeasureCoords getPrevMeasure(MeasureCoords measureCoords){
    	int prevNumber = measureCoords.getMeasure().getNumber() - 1;
    	int prevIndex = prevNumber - 1;
        if(prevIndex >= 0){
            return (MeasureCoords)measuresCoords.get(prevIndex);
        }        
        return null;
    }      
    
    public MeasureCoords getNextMeasure(MeasureCoords measureCoords){
    	int nextNumber = measureCoords.getMeasure().getNumber() + 1; 
    	int nextIndex = nextNumber - 1; 
        if(nextIndex < measuresCoords.size()){
            return (MeasureCoords)measuresCoords.get(nextIndex);
        }
        return null;        
    }       

    public MeasureCoords getMeasureCoords(long start){
        MeasureCoords measureCoords = null;
        for (int measureIdx = 0; measureIdx < this.measuresCoords.size(); measureIdx++) {
            MeasureCoords measure = (MeasureCoords) this.measuresCoords.get(measureIdx);  
            long measureStart = measure.getMeasure().getStart();
            long measureLength = measure.getMeasure().getLength();
            if(start >= measureStart && start < measureStart + measureLength){
                return measure;
            }
        }     
        return null;
    }          
    
    public MeasureCoords getMeasure(Measure measure){
        MeasureCoords measureCoords = null;
        for (int measureIdx = 0; measureIdx < this.measuresCoords.size(); measureIdx++) {
            MeasureCoords currMeasure = (MeasureCoords) this.measuresCoords.get(measureIdx);            
            if(currMeasure.getMeasure().equals(measure)){
                measureCoords = currMeasure;
                break;
            }
        }     
        return measureCoords;
    }      

    public MeasureCoords getMeasureAt(int x,int y){
    	MeasureCoords measure = null;     
    	int minorDistance = 0;
        
        
        Iterator it = measuresCoords.iterator();
        while(it.hasNext()){           
            MeasureCoords m = (MeasureCoords)it.next();
        	if(!m.isOutOfBounds() && m.getTs() != null){            
        		boolean isAtX = (x >= m.getPosX() && x <= m.getPosX() + m.getWidth() + m.getSpan());
        		if(isAtX){
        			int measureHeight = m.getTs().getSize();
        			int distanceY = Math.min(Math.abs(y - (m.getPosY())),Math.abs(y - ( m.getPosY() + measureHeight - 10)));
        			if(measure == null || distanceY < minorDistance){
        				measure = m;
        				minorDistance = distanceY;
        			}
        		}
        	}
        }        
            
        return measure;
    }
    
    public boolean hasCaret(){
        return (this.equals(this.tablature.getCaret().getSongTrackCoords()));
    }

    public int getTabHeight() {
		return tabHeight;
	}
    
    public int getScoreHeight() {
		return scoreHeight;
	}

	public void setTabHeight(int tabHeight) {
		this.tabHeight = tabHeight;
	}

	public LyricPainter getLyricPainter(){
    	return this.lyricPainter;
    }
}