package org.herac.tuxguitar.gui.editors.tab.edit;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.system.config.ConfigKeys;
import org.herac.tuxguitar.song.models.InstrumentString;

public class EditorKit implements MouseListener,MouseMoveListener,MouseTrackListener{
	public static final int MOUSE_MODE_SELECTION = 1;
	
	public static final int MOUSE_MODE_EDITION = 2;

	private int mouseMode;
	private boolean natural;
	private Tablature tablature;
	private MouseKit mouseKit;
	
	public EditorKit(Tablature tablature){
		this.tablature = tablature;		
        this.mouseKit = new MouseKit(this);
        this.tablature.addMouseMoveListener(this);
        this.tablature.addMouseListener(this);
        this.tablature.addMouseTrackListener(this);
        this.setDefaults();
	}

	private void setDefaults(){		
		this.setMouseMode(TuxGuitar.instance().getConfig().getIntConfigValue(ConfigKeys.EDITOR_MOUSE_MODE,MOUSE_MODE_EDITION));
		this.setNatural(TuxGuitar.instance().getConfig().getBooleanConfigValue(ConfigKeys.EDITOR_NATURAL_KEY_MODE,true));
	}
	
	public int getMouseMode() {
		return mouseMode;
	}


	public void setMouseMode(int mouseMode) {
		this.mouseMode = mouseMode;
	}
	
	public boolean isNatural() {
		return natural;
	}

	public void setNatural(boolean natural) {
		this.natural = natural;
	}


	public Tablature getTablature() {
		return tablature;
	}	
	

	public void tryBack(){
		this.mouseKit.tryBack();
	}
	
	
    public boolean select(int x, int y) {
        if(x >= 0 && y >= 0){
           	SongTrackCoords trackCoords = getTrackCoords(y);
           	if (trackCoords != null) {
           		MeasureCoords measureCoords = getMeasureCoords(trackCoords, x,y);
           		if (measureCoords != null) {
           			MeasureComponent measureComponent = getMeasureComponent(measureCoords, x);
           			InstrumentString instrumentString = getMeasureString(measureCoords, y);
           			if (measureComponent != null) {
           				int string = (instrumentString != null)?instrumentString.getNumber():getTablature().getCaret().getSelectedString().getNumber();           				
           				getTablature().getCaret().moveTo(trackCoords, measureCoords, measureComponent, string);
           			}           			
           			return true;	
           		}
           	}           	
        }
        return false;
    }

    public SongTrackCoords getTrackCoords(int y) {
        return getTablature().getSongCoords().getTrackAt(y/*, -getTablature().getVerticalBar().getSelection()*/);
    }

    public MeasureCoords getMeasureCoords(SongTrackCoords trackCoords, int x,int y) {
        return trackCoords.getMeasureAt(x,y/*, -getTablature().getHorizontalBar().getSelection(),-getTablature().getVerticalBar().getSelection()*/);
    }    

    public MeasureComponent getMeasureComponent(MeasureCoords measureCoords, int x) {
        return measureCoords.getComponentAt(x);
    }

    public InstrumentString getMeasureString(MeasureCoords measureCoords, int y) {
        return measureCoords.getStringAt(y);
    }

    
    
	public void mouseDown(MouseEvent e) {
		select(e.x, e.y);
		//if(select(e.x, e.y)){
			//TuxGuitar.instance().redraw();
			//TuxGuitar.instance().updateCache(true);
		//}
	}

	public void mouseUp(MouseEvent e) {
		if(select(e.x, e.y)){
			TuxGuitar.instance().redraw();
			TuxGuitar.instance().updateCache(true);						
			if(!TuxGuitar.instance().getPlayer().isRunning() && getTablature().getViewLayout().isScoreEnabled() && getMouseMode() == MOUSE_MODE_EDITION){
				//if(getTablature().getViewLayout().isScoreEnabled() && getMouseMode() == MOUSE_MODE_EDITION && select(e.x, e.y)){
					this.mouseKit.mouseUp(e);
				//}						
			}
		}
	}

	public void mouseMove(MouseEvent e) {
		if(!TuxGuitar.instance().getPlayer().isRunning()){
			if(getTablature().getViewLayout().isScoreEnabled() && getMouseMode() == MOUSE_MODE_EDITION){
				this.mouseKit.mouseMove(e);
			}
		}
	}

	public void mouseExit(MouseEvent e) {
		if(!TuxGuitar.instance().getPlayer().isRunning()){
			if(getTablature().getViewLayout().isScoreEnabled() && getMouseMode() == MOUSE_MODE_EDITION){
				this.mouseKit.mouseExit(e);
			}
		}
	}
	
	public void mouseDoubleClick(MouseEvent e) {		
	}
	public void mouseEnter(MouseEvent e) {		
	}
	public void mouseHover(MouseEvent e) {	
	}	
}
