/*
 * Created on 04-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.editors.tab.layout;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.song.managers.SongManager;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PageViewLayout extends ViewLayout{
    private int displayWidth;
    private int divisionCount;
    
    public PageViewLayout(Tablature tablature,SongManager songManager,boolean multitrack,boolean scoreEnabled,boolean tablatureEnabled){
        super(tablature,songManager,multitrack,scoreEnabled,tablatureEnabled);
        this.displayWidth = (getTablature().getDisplay().getBounds().width - getTablature().getVerticalBar().getSize().x);
    }
    
    public int getMode(){
    	return MODE_PAGE;
    }
        
    public void paintSong(GC gc,Rectangle clientArea,int fromX,int fromY){ 
    	clearTrackPositions();
        if(isMultitrack()){
            paintTracks(getTablature().getCaret().getSongCoords().getTrackCoords(),gc,clientArea,fromX,fromY);
        }else{
            List tracksCoords = new ArrayList();
            tracksCoords.add(getTablature().getCaret().getSongTrackCoords());
            paintTracks(tracksCoords,gc,clientArea,fromX,fromY);
        }
        
        paintCaret(gc);
    }
    
    public void paintTracks(List tracksCoords,GC gc,Rectangle clientArea,int fromX,int fromY) {    	
    	int posY = fromY + getDefaultFirstTrackSpan();
    	int height = getDefaultFirstTrackSpan();
    	int lineHeight = 0;    	
    	
    	SongTrackCoords firstTrack = (SongTrackCoords)tracksCoords.get(0);
    	int measureCount = firstTrack.getMeasuresCoords().size();
    	int nextMeasureIndex = 0;
    	while(measureCount > nextMeasureIndex){    	
    		TempLine line = null;    		
    		for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
    			SongTrackCoords trackCoords = (SongTrackCoords) tracksCoords.get(trackIdx);    			    			
                TrackSpacing ts = new TrackSpacing(this) ;
                ts.setSize(TrackSpacing.POSITION_SCORE_MIDDLE_LINES, ((isScoreEnabled())?( (DEFAULT_SCORE_LINE_SPAN * 5) ):0));
                    			
    			if(nextMeasureIndex == 0){
    				trackCoords.getLyricPainter().start();
    			}
    			
    			line = getTempLines(fromX,trackCoords.getMeasuresCoords(),nextMeasureIndex,ts);
    			if(AUTO_SPACING_ENABLED && isScoreEnabled()){    			
                	ts.setSize(TrackSpacing.POSITION_SCORE_UP_LINES, Math.abs(line.minY));            	            
                	if(isScoreEnabled() && line.maxY + MIN_SCORE_TAB_SPAN > DEFAULT_SCORE_SPAN){
                		ts.setSize(TrackSpacing.POSITION_SCORE_DOWN_LINES, (line.maxY - (getScoreLineSpan() * 4)) );
                	}	
    			}    	
                ts.setSize(TrackSpacing.POSITION_TABLATURE_TOP_SEPARATOR,(isScoreEnabled()?getMinScoreTabSpan():getStringSpan()));
                ts.setSize(TrackSpacing.POSITION_TABLATURE, ( isTablatureEnabled()?(isScoreEnabled()?trackCoords.getTabHeight() + getStringSpan() +1:trackCoords.getTabHeight() + ((getStringSpan() / 2) * 5) +1 ) :0) );
                ts.setSize(TrackSpacing.POSITION_LYRIC,10);            
                checkTopSpan(ts);
    			                
    			paintLine(trackCoords,line,gc,fromX,posY,ts,trackIdx,clientArea);
    			
    			lineHeight = ts.getSize();
    			addTrackPosition((int)trackCoords.getTrack().getNumber(),posY,lineHeight);		
    			if((line.lastIndex + 1) >=  measureCount && line.tempWith < (getMaxWidth() - 20)){    		            		 			
            		paintLines(trackCoords,ts,gc,(fromX + DEFAULT_HORIZONTAL_SPAN + line.tempWith + 2),posY,((getMaxWidth() - 15) - (fromX + line.tempWith)));            		
    			}                
    			
                posY += lineHeight + DEFAULT_TRACK_SPAN;
    			height += lineHeight + DEFAULT_TRACK_SPAN;
    		}        
    		nextMeasureIndex = line.lastIndex + 1;
    	}    	
    	setHeight(height);
    }
    
    
    
    public void paintLine(SongTrackCoords trackCoords,TempLine line,GC gc,int fromX, int fromY,TrackSpacing ts,int trackIdx,Rectangle clientArea) {          
    	int posX = (fromX + DEFAULT_HORIZONTAL_SPAN);
        int posY = fromY;
        int width = 0;
        int height = 0;        
        
        //verifico si esta en el area de cliente
        boolean isAtX = ((posX + fromX) > clientArea.x - 1500 && (posX + fromX) < clientArea.x + clientArea.width + 100);
        boolean isAtY = (posY + ts.getSize() > clientArea.y && posY < clientArea.y + clientArea.height + 80);

        int measureSpan = 0;
        if(line.fullLine){
        	int diff = ( getMaxWidth() - line.tempWith);
        	if(diff != 0 && line.measures.size() > 0){
        		measureSpan = diff / line.measures.size();                    
        	}
        }
            
        for(int i = 0;i < line.measures.size();i ++){
          	int index = ((Integer)line.measures.get(i)).intValue();
            MeasureCoords currMeasureCoords = (MeasureCoords)trackCoords.getMeasuresCoords().get(index);
                    
            //asigno la posicion dentro del compas
            currMeasureCoords.setPosX(posX);
            currMeasureCoords.setPosY(posY);              
            currMeasureCoords.setTs(ts);

            trackCoords.getLyricPainter().setCurrentMeasure(currMeasureCoords);
            
            currMeasureCoords.setFirstOfLine(i == 0);
                
            if(isAtX && isAtY){
            	paintMeasure(currMeasureCoords,gc,posX, posY,measureSpan,clientArea);
            	trackCoords.getLyricPainter().paintCurrentNoteBeats(gc,this,currMeasureCoords,posX, posY);
            }else{
            	currMeasureCoords.setOutOfBounds(true);
            }                    
            posX += currMeasureCoords.getWidth() + currMeasureCoords.getSpan();
            
            if(posX > width){
                width = posX;                
            }                                                        
        }                
        setWidth((width > getWidth())?width:getWidth());
    }          
   
    
    public TempLine getTempLines(int posX,List measuresCoords,int fromIndex,TrackSpacing ts) {          
    	TempLine line = new TempLine();
    	this.divisionCount = 1;                    	
        for (int measureIdx = fromIndex; measureIdx < measuresCoords.size(); measureIdx++) {        	        	
            MeasureCoords measureCoords = (MeasureCoords) measuresCoords.get(measureIdx);                                            

            //verifico si tengo que bajar de linea
            if((line.tempWith + measureCoords.getWidth()) >=  getMaxWidth() && !line.measures.isEmpty()){
            	line.fullLine = true;
            	return line;
            }
            line.tempWith +=  measureCoords.getWidth();
            line.maxY = (measureCoords.getMaxY() > line.maxY)?measureCoords.getMaxY():line.maxY;
            line.minY = (measureCoords.getMinY() < line.minY)?measureCoords.getMinY():line.minY;        	
            
            line.addMeasure(measureIdx);
            measureCoords.registerEffects(ts);
        }        
       
        return line;
    }    

    public boolean followMeasure(MeasureCoords measure,boolean redraw){
    	return getTablature().moveScrollVerticalTo(measure,getDefaultFirstTrackSpan(),redraw);
    }       

    public int getMaxWidth(){
        return (displayWidth - (DEFAULT_HORIZONTAL_SPAN * 2));
    }
        
    private class TempLine{    	
    	private int tempWith;    	
    	private int lastIndex;
    	private int startBeat;
    	private boolean fullLine;
    	private List measures = new ArrayList();
    	
    	private int maxY = 0;
    	private int minY = 0;
    	
    	private void addMeasure(int index){
    		this.measures.add(new Integer(index));
    		this.lastIndex = index;
    	}
    }
    
}
