package org.herac.tuxguitar.gui.effects;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.VelocityValues;
import org.herac.tuxguitar.song.models.effects.GraceEffect;

public class GraceEditor extends SelectionAdapter{

	public static final int WIDTH = 400;
	
	public static final int HEIGHT = 0;
		
	private Spinner fretSpinner;
	private Button deadButton;
	private Button beforeBeatButton;
	private Button onBeatButton;
	private Button durationButton1;
	private Button durationButton2;
	private Button durationButton3;
	private Button pppButton;
	private Button ppButton;
	private Button pButton;
	private Button mpButton;
	private Button mfButton;
	private Button fButton;
	private Button ffButton;
	private Button fffButton;	
	private Button noneButton;
	private Button slideButton;
	private Button bendButton;
	private Button hammerButton;
	
	private GraceEffect result;
	
	public GraceEditor(){
		
	}
	
	private static final int LAYOUT_COLUMNS = 2;
	
	public GraceEffect show(final Note note){
		final Shell shell = TuxGuitar.instance().getShell();
		final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

        dialog.setLayout(new GridLayout());
        dialog.setText(TuxGuitar.getProperty("effects.grace-editor"));
        
        
        Composite composite = new Composite(dialog,SWT.NONE);
        composite.setLayout(new GridLayout(LAYOUT_COLUMNS,false));
        composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
        
        int horizontalSpan = 2;
        
        //-----defaults-------------------------------------------------
		boolean dead = false;
		boolean onBeat = false;
		int fret = note.getValue();
		int duration = 1;
		int dynamic = VelocityValues.DEFAULT;
		int transition = GraceEffect.TRANSITION_NONE;
        if(note.getEffect().isGrace()){        	
        	dead = note.getEffect().getGrace().isDead();
        	fret = note.getEffect().getGrace().getFret();
        	onBeat = note.getEffect().getGrace().isOnBeat();
        	duration = note.getEffect().getGrace().getDuration();
        	dynamic = note.getEffect().getGrace().getDynamic();
        	transition = note.getEffect().getGrace().getTransition();
        }        
    	//---------------------------------------------------
        //------------------NOTE-----------------------------
    	//---------------------------------------------------
        Group noteGroup = makeGroup(composite,horizontalSpan, TuxGuitar.getProperty("note"));        
        noteGroup.setLayout(new GridLayout(2,false));
        
        Label fretLabel = new Label(noteGroup,SWT.NONE);
        
        fretLabel.setText(TuxGuitar.getProperty("fret") + ": ");
        //fretLabel.setLayoutData(makeGridData(1));
        
        fretSpinner = new Spinner(noteGroup,SWT.BORDER);
        fretSpinner.setLayoutData(makeGridData(1));
        fretSpinner.setSelection(fret);
        
        deadButton = new Button(noteGroup,SWT.CHECK);
        deadButton.setText(TuxGuitar.getProperty("note.deadnote"));
        deadButton.setLayoutData(makeGridData(2));
        deadButton.setSelection(dead);
    	//---------------------------------------------------
        //------------------POSITION--------------------------
    	//---------------------------------------------------
        Group positionGroup = makeGroup(composite,horizontalSpan, TuxGuitar.getProperty("position"));        
        positionGroup.setLayout(new GridLayout());
        
        beforeBeatButton = new Button(positionGroup,SWT.RADIO);
        beforeBeatButton.setText(TuxGuitar.getProperty("effects.grace.before-beat"));
        beforeBeatButton.setLayoutData(makeGridData(1));
        beforeBeatButton.setSelection(!onBeat);
        
        onBeatButton = new Button(positionGroup,SWT.RADIO);
        onBeatButton.setText(TuxGuitar.getProperty("effects.grace.on-beat"));
        onBeatButton.setLayoutData(makeGridData(1));
        onBeatButton.setSelection(onBeat);
    	//---------------------------------------------------
        //------------------DURATION-------------------------
    	//---------------------------------------------------
        Group durationGroup = makeGroup(composite,horizontalSpan, TuxGuitar.getProperty("duration"));
        durationGroup.setLayout(new GridLayout(3,false));
        
        durationButton1 = new Button(durationGroup,SWT.RADIO);
        durationButton1.setImage(SystemImages.getDuration(Duration.SIXTY_FOURTH));
        durationButton1.setLayoutData(makeGridData(1));
        durationButton1.setSelection(duration == 1);
        
        durationButton2 = new Button(durationGroup,SWT.RADIO);
        durationButton2.setImage(SystemImages.getDuration(Duration.THIRTY_SECOND));
        durationButton2.setLayoutData(makeGridData(1));
        durationButton2.setSelection(duration == 2);
        
        durationButton3 = new Button(durationGroup,SWT.RADIO);
        durationButton3.setImage(SystemImages.getDuration(Duration.SIXTEENTH));
        durationButton3.setLayoutData(makeGridData(1));        
        durationButton3.setSelection(duration == 3);
        
        horizontalSpan = 1;
    	//---------------------------------------------------
        //------------------DYNAMIC--------------------------
    	//---------------------------------------------------
        Group dynamicGroup = makeGroup(composite,horizontalSpan, TuxGuitar.getProperty("dynamic"));        
        dynamicGroup.setLayout(new GridLayout(2,false));
        
        pppButton = new Button(dynamicGroup,SWT.RADIO);
        pppButton.setImage(SystemImages.DYNAMIC_PIANO_PIANISSIMO);
        pppButton.setLayoutData(makeGridData(1));
        pppButton.setSelection(dynamic == VelocityValues.PIANO_PIANISSIMO);
        
        mfButton = new Button(dynamicGroup,SWT.RADIO);
        mfButton.setImage(SystemImages.DYNAMIC_MEZZO_FORTE);
        mfButton.setLayoutData(makeGridData(1));
        mfButton.setSelection(dynamic == VelocityValues.MEZZO_FORTE);
        
        ppButton = new Button(dynamicGroup,SWT.RADIO);
        ppButton.setImage(SystemImages.DYNAMIC_PIANISSIMO);
        ppButton.setLayoutData(makeGridData(1));
        ppButton.setSelection(dynamic == VelocityValues.PIANISSIMO);
        
        fButton = new Button(dynamicGroup,SWT.RADIO);
        fButton.setImage(SystemImages.DYNAMIC_FORTE);
        fButton.setLayoutData(makeGridData(1));
        fButton.setSelection(dynamic == VelocityValues.FORTE);
        
        pButton = new Button(dynamicGroup,SWT.RADIO);
        pButton.setImage(SystemImages.DYNAMIC_PIANO);
        pButton.setLayoutData(makeGridData(1));        
        pButton.setSelection(dynamic == VelocityValues.PIANO);
        
        ffButton = new Button(dynamicGroup,SWT.RADIO);
        ffButton.setImage(SystemImages.DYNAMIC_FORTISSIMO);
        ffButton.setLayoutData(makeGridData(1));
        ffButton.setSelection(dynamic == VelocityValues.FORTISSIMO);
        
        mpButton = new Button(dynamicGroup,SWT.RADIO);
        mpButton.setImage(SystemImages.DYNAMIC_MEZZO_PIANO);
        mpButton.setLayoutData(makeGridData(1));    
        mpButton.setSelection(dynamic == VelocityValues.MEZZO_PIANO);
        
        fffButton = new Button(dynamicGroup,SWT.RADIO);
        fffButton.setImage(SystemImages.DYNAMIC_FORTE_FORTISSIMO);
        fffButton.setLayoutData(makeGridData(1));      
        fffButton.setSelection(dynamic == VelocityValues.FORTE_FORTISSIMO);
    	//---------------------------------------------------
        //------------------TRANSITION-----------------------
    	//---------------------------------------------------
        Group transitionGroup = makeGroup(composite,horizontalSpan, TuxGuitar.getProperty("effects.grace.transition"));        
        transitionGroup.setLayout(new GridLayout());
        
        noneButton = new Button(transitionGroup,SWT.RADIO);
        noneButton.setText(TuxGuitar.getProperty("effects.grace.transition-none"));
        noneButton.setLayoutData(makeGridData(1));
        noneButton.setSelection(transition == GraceEffect.TRANSITION_NONE);
        
        bendButton = new Button(transitionGroup,SWT.RADIO);
        bendButton.setText(TuxGuitar.getProperty("effects.grace.transition-bend"));
        bendButton.setLayoutData(makeGridData(1));              
        bendButton.setSelection(transition == GraceEffect.TRANSITION_BEND);
        
        slideButton = new Button(transitionGroup,SWT.RADIO);
        slideButton.setText(TuxGuitar.getProperty("effects.grace.transition-slide"));
        slideButton.setLayoutData(makeGridData(1));        
        slideButton.setSelection(transition == GraceEffect.TRANSITION_SLIDE);
        
        hammerButton = new Button(transitionGroup,SWT.RADIO);
        hammerButton.setText(TuxGuitar.getProperty("effects.grace.transition-hammer"));
        hammerButton.setLayoutData(makeGridData(1));                
        hammerButton.setSelection(transition == GraceEffect.TRANSITION_HAMMER);
    	//---------------------------------------------------
        //------------------BUTTONS--------------------------
    	//---------------------------------------------------
        Composite buttons = new Composite(dialog, SWT.NONE);
        buttons.setLayout(new GridLayout(3,false));
        buttons.setLayoutData(new GridData(SWT.END,SWT.BOTTOM,true,true));    	
        
        GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
        data.minimumWidth = 80;
        data.minimumHeight = 25;     
        
        final Button buttonOK = new Button(buttons, SWT.PUSH);
        buttonOK.setText(TuxGuitar.getProperty("ok"));        
        buttonOK.setLayoutData(data);
        buttonOK.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {   
            	result = getGrace();
                dialog.dispose();
            }
        });

        Button buttonClean = new Button(buttons, SWT.PUSH);
        buttonClean.setText(TuxGuitar.getProperty("clean"));
        buttonClean.setLayoutData(data);
        buttonClean.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
            	result = null;
                dialog.dispose();
            }
        });        
        
        Button buttonCancel = new Button(buttons, SWT.PUSH);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData(data);
        buttonCancel.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
            	result = note.getEffect().getGrace();
                dialog.dispose();
            }
        });

        dialog.setMinimumSize(360,360);
        dialog.pack();
        dialog.open();

        int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
        int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
        dialog.setLocation(x, y);
        
		while (!dialog.isDisposed()) {
            if (!dialog.getDisplay().readAndDispatch()) {
            	dialog.getDisplay().sleep();
            }
        }		
	
		return result;
	}
	
	private GridData resizeData(GridData data,int minWidth){
		data.minimumWidth = minWidth;
		
		return data;
	}
	
	private Group makeGroup(Composite parent,int horizontalSpan,String text){
        Group group = new Group(parent, SWT.SHADOW_ETCHED_IN);
        group.setLayoutData(makeGridData(horizontalSpan));
        group.setText(text);
        
        return group;
	}
	
	
	private GridData makeGridData(int horizontalSpan){
		GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);		
		data.horizontalSpan = horizontalSpan;		
		return data;
	}	
	
	public GraceEffect getGrace(){				
		int fret = fretSpinner.getSelection();			
		boolean dead = deadButton.getSelection();
		boolean onBeat = onBeatButton.getSelection();
		
		//duration
		int duration = 0;
		if(durationButton1.getSelection()){
			duration = 1;
		}else if(durationButton2.getSelection()){
			duration = 2;
		}if(durationButton3.getSelection()){
			duration = 3;
		}
		//velocity
		int dynamic = 0;
		if(pppButton.getSelection()){
			dynamic = VelocityValues.PIANO_PIANISSIMO;		
		}else if(ppButton.getSelection()){
			dynamic = VelocityValues.PIANISSIMO;		
		}else if(pButton.getSelection()){
			dynamic = VelocityValues.PIANO;		
		}else if(mpButton.getSelection()){
			dynamic = VelocityValues.MEZZO_PIANO;			
		}else if(mfButton.getSelection()){
			dynamic = VelocityValues.MEZZO_FORTE;		
		}else if(fButton.getSelection()){
			dynamic = VelocityValues.FORTE;		
		}else if(ffButton.getSelection()){
			dynamic = VelocityValues.FORTISSIMO;		
		}else if(fffButton.getSelection()){
			dynamic = VelocityValues.FORTE_FORTISSIMO;
		}
		
		int transition = 0;
		if(noneButton.getSelection()){
			transition = GraceEffect.TRANSITION_NONE;
		}else if(slideButton.getSelection()){
			transition = GraceEffect.TRANSITION_SLIDE;
		}else if(bendButton.getSelection()){
			transition = GraceEffect.TRANSITION_BEND;
		}else if(hammerButton.getSelection()){
			transition = GraceEffect.TRANSITION_HAMMER;
		}  
		
		return new GraceEffect(fret,duration,dynamic,transition,onBeat,dead);
	}	
	

}
