package org.herac.tuxguitar.gui.effects;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.effects.HarmonicEffect;

public class HarmonicEditor extends SelectionAdapter{

	public static final int WIDTH = 400;
	
	public static final int HEIGHT = 0;
	
	private Button natural;
	
	private Button artificial;
	
	private Button tapped;
	
	private Button pinch;
	
	private Button semi;
	
	private Label artificialLabel;
	private Combo artificialKey;		
		
	private Label tappedLeftHand;	
	private Label tappedLeftHandSelection;
	private Label tappedRightHand;	
	private Combo tappedSelection;
	
	private HarmonicEffect result;
	
	public HarmonicEditor(){
		
	}
	
	public HarmonicEffect show(final Note note){
		final Shell shell = TuxGuitar.instance().getShell();
		final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

        dialog.setLayout(new GridLayout());
        dialog.setText(TuxGuitar.getProperty("effects.harmonic-editor"));
        
        Group group = new Group(dialog, SWT.SHADOW_ETCHED_IN);
        group.setLayout(new GridLayout());
        group.setLayoutData(resizeData(new GridData(SWT.FILL,SWT.FILL,true,true),WIDTH)); 
        group.setText(TuxGuitar.getProperty("effects.harmonic.type-of-harmonic"));               

    	//---------------------------------------------------------------------        
        //------------NATURAL--------------------------------------------------
    	//---------------------------------------------------------------------        
        this.natural = new Button(group,SWT.RADIO);
        this.natural.setText("[" + HarmonicEffect.KEY_NATURAL + "] " + TuxGuitar.getProperty("effects.harmonic.natural"));
        this.natural.setLayoutData(new GridData(SWT.LEFT,SWT.FILL,true,true)); 
        this.natural.addSelectionListener(this);
        this.natural.setSelection(note.getEffect().isHarmonic() && note.getEffect().getHarmonic().isNatural());
        
    	//---------------------------------------------------------------------        
        //------------ARTIFICIAL-----------------------------------------------
    	//---------------------------------------------------------------------        
        this.artificial = new Button(group,SWT.RADIO);
        this.artificial.setText("[" + HarmonicEffect.KEY_ARTIFICIAL + "] " + TuxGuitar.getProperty("effects.harmonic.artificial"));
        this.artificial.setLayoutData(new GridData(SWT.LEFT,SWT.FILL,true,true)); 
        this.artificial.addSelectionListener(this);
        this.artificial.setSelection(note.getEffect().isHarmonic() && note.getEffect().getHarmonic().isArtificial());
                
        Composite aComposite = new Composite(group,SWT.NONE);
        aComposite.setLayout(new GridLayout(2,false));
        aComposite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));    
                
        this.artificialLabel = new Label(aComposite,SWT.NONE);
        this.artificialLabel.setText(TuxGuitar.getProperty("effects.harmonic.artificial.key-offset"));
        this.artificialLabel.setLayoutData(new GridData(SWT.NONE,SWT.CENTER,false,true));
        
        this.artificialKey = new Combo(aComposite,SWT.DROP_DOWN | SWT.READ_ONLY);
        this.artificialKey.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
        for(int i = HarmonicEffect.MIN_ARTIFICIAL_OFFSET;i <= HarmonicEffect.MAX_ARTIFICIAL_OFFSET;i ++){
        	this.artificialKey.add(Integer.toString(i));
        }   
    	if(note.getEffect().isHarmonic() && note.getEffect().getHarmonic().isArtificial()){
    		this.artificialKey.select(note.getEffect().getHarmonic().getData() - HarmonicEffect.MIN_ARTIFICIAL_OFFSET);
    	}else{
    		this.artificialKey.select(-HarmonicEffect.MIN_ARTIFICIAL_OFFSET);
    	}
    	//---------------------------------------------------------------------   
        //------------TAPPED---------------------------------------------------
    	//---------------------------------------------------------------------    	
        this.tapped = new Button(group,SWT.RADIO);
        this.tapped.setText("[" + HarmonicEffect.KEY_TAPPED + "] " + TuxGuitar.getProperty("effects.harmonic.tapped"));
        this.tapped.setLayoutData(new GridData(SWT.LEFT,SWT.FILL,true,true)); 
        this.tapped.addSelectionListener(this);
        this.tapped.setSelection(note.getEffect().isHarmonic() && note.getEffect().getHarmonic().isTapped());
        
        Composite tComposite = new Composite(group,SWT.NONE);
        tComposite.setLayout(new GridLayout(2,false));
        tComposite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));         

        this.tappedLeftHand = new Label(tComposite,SWT.NONE);
        this.tappedLeftHand.setText(TuxGuitar.getProperty("effects.harmonic.tapped.left-hand") + ":"); 
        this.tappedLeftHand.setLayoutData(new GridData(SWT.NONE,SWT.CENTER,false,true));  
        
        this.tappedLeftHandSelection = new Label(tComposite,SWT.NONE);
        this.tappedLeftHandSelection.setLayoutData(new GridData(SWT.LEFT,SWT.CENTER,true,true));  
        this.tappedLeftHandSelection.setText(" 1");
        
        this.tappedRightHand = new Label(tComposite,SWT.NONE);
        this.tappedRightHand.setText(TuxGuitar.getProperty("effects.harmonic.tapped.right-hand") + ":");        
        this.tappedRightHand.setLayoutData(new GridData(SWT.NONE,SWT.CENTER,false,true)); 
        
        this.tappedSelection = new Combo(tComposite,SWT.DROP_DOWN | SWT.READ_ONLY);       
        this.tappedSelection.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
        for(int i = note.getValue();i <= HarmonicEffect.MAX_TAPPED_OFFSET;i ++){
        	this.tappedSelection.add(Integer.toString(i));
        }        
        if(note.getEffect().isHarmonic() && note.getEffect().getHarmonic().isTapped()){        	
        	this.tappedSelection.select(note.getEffect().getHarmonic().getData());
        }else{
        	this.tappedSelection.select(0);
        }

    	//--------------------------------------------------------------------        
        //------------PINCH---------------------------------------------------
    	//--------------------------------------------------------------------        
        this.pinch = new Button(group,SWT.RADIO);
        this.pinch.setText("[" + HarmonicEffect.KEY_PINCH + "] " + TuxGuitar.getProperty("effects.harmonic.pinch"));
        this.pinch.setLayoutData(new GridData(SWT.LEFT,SWT.FILL,true,true)); 
        this.pinch.addSelectionListener(this);
        this.pinch.setSelection(note.getEffect().isHarmonic() && note.getEffect().getHarmonic().isPinch());
        
    	//-------------------------------------------------------------------        
        //------------SEMI---------------------------------------------------
    	//-------------------------------------------------------------------        
        this.semi = new Button(group,SWT.RADIO);
        this.semi.setText("[" + HarmonicEffect.KEY_SEMI + "] " + TuxGuitar.getProperty("effects.harmonic.semi"));
        this.semi.setLayoutData(new GridData(SWT.LEFT,SWT.FILL,true,true));
        this.semi.addSelectionListener(this);
        this.semi.setSelection(note.getEffect().isHarmonic() && note.getEffect().getHarmonic().isSemi());
        
    	//---------------------------------------------------
        //------------------BUTTONS--------------------------
    	//---------------------------------------------------
        Composite buttons = new Composite(dialog, SWT.NONE);
        buttons.setLayout(new GridLayout(3,false));
        buttons.setLayoutData(new GridData(SWT.END,SWT.BOTTOM,true,true));    	
        
        GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
        data.minimumWidth = 80;
        data.minimumHeight = 25;     
        
        final Button buttonOK = new Button(buttons, SWT.PUSH);
        buttonOK.setText(TuxGuitar.getProperty("ok"));        
        buttonOK.setLayoutData(data);
        buttonOK.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {   
            	result = getHarmonic();
                dialog.dispose();
            }
        });

        Button buttonClean = new Button(buttons, SWT.PUSH);
        buttonClean.setText(TuxGuitar.getProperty("clean"));
        buttonClean.setLayoutData(data);
        buttonClean.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
            	result = null;
                dialog.dispose();
            }
        });        
        
        Button buttonCancel = new Button(buttons, SWT.PUSH);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData(data);
        buttonCancel.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
            	result = note.getEffect().getHarmonic();
                dialog.dispose();
            }
        });

        
        if(!note.getEffect().isHarmonic()){
        	this.natural.setSelection(true);
        }        
        updateControls();        
        dialog.pack();
        dialog.open();

        int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
        int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
        dialog.setLocation(x, y);
        
		while (!dialog.isDisposed()) {
            if (!dialog.getDisplay().readAndDispatch()) {
            	dialog.getDisplay().sleep();
            }
        }		
	
		return result;
	}
	
	private GridData resizeData(GridData data,int minWidth){
		data.minimumWidth = minWidth;	
		return data;
	}
	
	private GridData spanData(GridData data,int horizontalSpan){
		data.horizontalSpan = horizontalSpan;		
		return data;
	}	
	
	public void widgetSelected(SelectionEvent e) {
		updateControls();
	}
	
	public void updateControls(){
		this.artificialLabel.setEnabled(this.artificial.getSelection());
		this.artificialKey.setEnabled(this.artificial.getSelection());			
		this.tappedLeftHand.setEnabled(this.tapped.getSelection());
		this.tappedLeftHandSelection.setEnabled(this.tapped.getSelection());
		this.tappedRightHand.setEnabled(this.tapped.getSelection());
		this.tappedSelection.setEnabled(this.tapped.getSelection());
	}
	
	
	public HarmonicEffect getHarmonic(){				
		if(natural.getSelection()){
			return new HarmonicEffect(HarmonicEffect.TYPE_NATURAL);
		}
		else if(artificial.getSelection()){
			return new HarmonicEffect(HarmonicEffect.TYPE_ARTIFICIAL,HarmonicEffect.MIN_ARTIFICIAL_OFFSET + artificialKey.getSelectionIndex());
		} 
		else if(tapped.getSelection()){
			return new HarmonicEffect(HarmonicEffect.TYPE_TAPPED,tappedSelection.getSelectionIndex());
		}
		else if(pinch.getSelection()){
			return new HarmonicEffect(HarmonicEffect.TYPE_PINCH);
		}
		else if(semi.getSelection()){
			return new HarmonicEffect(HarmonicEffect.TYPE_SEMI);
		}		

		return null;
	}	
	

}
