/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.note.ChangeVelocityAction;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.VelocityValues;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class DynamicMenuItem implements MenuItems{
    private TablatureEditor tablatureEditor;
    private MenuItem dynamicMenuItem;
    private Menu menu; 
    private MenuItem pianoPianissimo;
    private MenuItem pianissimo;
    private MenuItem piano;
    private MenuItem mezzoPiano;
    private MenuItem mezzoForte;
    private MenuItem forte;
    private MenuItem fortissimo;
    private MenuItem forteFortissimo;
    
    public DynamicMenuItem(Shell shell,Menu parent, int style,TablatureEditor tablatureEditor) {
        this.dynamicMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, SWT.DROP_DOWN);
    }    
    
    public void showItems(){                        

        this.pianoPianissimo = new MenuItem(this.menu, SWT.CHECK);        
        this.pianoPianissimo.setData(new Integer(VelocityValues.PIANO_PIANISSIMO));
        this.pianoPianissimo.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));
        
        this.pianissimo = new MenuItem(this.menu, SWT.CHECK);
        this.pianissimo.setData(new Integer(VelocityValues.PIANISSIMO));
        this.pianissimo.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));
        
        this.piano = new MenuItem(this.menu, SWT.CHECK);
        this.piano.setData(new Integer(VelocityValues.PIANO));
        this.piano.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));
        
        this.mezzoPiano = new MenuItem(this.menu, SWT.CHECK);
        this.mezzoPiano.setData(new Integer(VelocityValues.MEZZO_PIANO));
        this.mezzoPiano.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));
        
        this.mezzoForte = new MenuItem(this.menu, SWT.CHECK);
        this.mezzoForte.setData(new Integer(VelocityValues.MEZZO_FORTE));
        this.mezzoForte.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));
        
        this.forte = new MenuItem(this.menu, SWT.CHECK);
        this.forte.setData(new Integer(VelocityValues.FORTE));
        this.forte.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));
        
        this.fortissimo = new MenuItem(this.menu, SWT.CHECK);
        this.fortissimo.setData(new Integer(VelocityValues.FORTISSIMO));
        this.fortissimo.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));
        
        this.forteFortissimo = new MenuItem(this.menu, SWT.CHECK);
        this.forteFortissimo.setData(new Integer(VelocityValues.FORTE_FORTISSIMO));
        this.forteFortissimo.addSelectionListener(TuxGuitar.instance().getAction(ChangeVelocityAction.NAME));
        
        this.dynamicMenuItem.setMenu(menu);        
        this.loadProperties();
    }    
    
    public void update(){
    	Note note = tablatureEditor.getTablature().getCaret().getSelectedNote();
    	int velocity = ((note != null)?note.getVelocity():tablatureEditor.getTablature().getCaret().getVelocity());
    	
        this.pianoPianissimo.setSelection(velocity == VelocityValues.PIANO_PIANISSIMO);
        this.pianissimo.setSelection(velocity == VelocityValues.PIANISSIMO);
        this.piano.setSelection(velocity == VelocityValues.PIANO);
        this.mezzoPiano.setSelection(velocity == VelocityValues.MEZZO_PIANO);
        this.mezzoForte.setSelection(velocity == VelocityValues.MEZZO_FORTE);
        this.forte.setSelection(velocity == VelocityValues.FORTE);
        this.fortissimo.setSelection(velocity == VelocityValues.FORTISSIMO);
        this.forteFortissimo.setSelection(velocity == VelocityValues.FORTE_FORTISSIMO);
    }
           
    public void loadProperties(){
        this.dynamicMenuItem.setText(TuxGuitar.getProperty("dynamic"));        
        
        this.pianoPianissimo.setText(TuxGuitar.getProperty("dynamic.piano-pianissimo"));
        this.pianissimo.setText(TuxGuitar.getProperty("dynamic.pianissimo"));     
        this.piano.setText(TuxGuitar.getProperty("dynamic.piano"));
        this.mezzoPiano.setText(TuxGuitar.getProperty("dynamic.mezzo-piano"));        
        this.mezzoForte.setText(TuxGuitar.getProperty("dynamic.mezzo-forte"));        
        this.forte.setText(TuxGuitar.getProperty("dynamic.forte"));      
        this.fortissimo.setText(TuxGuitar.getProperty("dynamic.fortissimo"));   
        this.forteFortissimo.setText(TuxGuitar.getProperty("dynamic.forte-fortissimo"));
    }       
    
}
