/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.edit.RedoAction;
import org.herac.tuxguitar.gui.actions.edit.SetMouseModeEditionAction;
import org.herac.tuxguitar.gui.actions.edit.SetMouseModeSelectionAction;
import org.herac.tuxguitar.gui.actions.edit.SetNaturalKeyAction;
import org.herac.tuxguitar.gui.actions.edit.UndoAction;
import org.herac.tuxguitar.gui.editors.tab.edit.EditorKit;
import org.herac.tuxguitar.gui.items.ToolItems;
/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class EditToolItems extends ToolItems {
    public static final String NAME = "edit.items";
    private ToolBar toolBar;   
    private ToolItem undo;
    private ToolItem redo;
    
    private ToolItem modeSelection;
    private ToolItem modeEdition;
    private ToolItem notNaturalKey;    
    
    public EditToolItems(){
    	super(NAME);
    }
   
    public void showItems(ToolBar toolBar){
    	this.toolBar = toolBar;               
        this.undo = new ToolItem(toolBar, SWT.PUSH);
        this.undo.setImage(SystemImages.EDIT_UNDO);
        this.undo.addSelectionListener(TuxGuitar.instance().getAction(UndoAction.NAME));
       
        this.redo = new ToolItem(toolBar, SWT.PUSH);
        this.redo.setImage(SystemImages.EDIT_REDO);
        this.redo.addSelectionListener(TuxGuitar.instance().getAction(RedoAction.NAME));

        new ToolItem(toolBar, SWT.SEPARATOR);
        
        this.modeSelection = new ToolItem(toolBar, SWT.RADIO);
        this.modeSelection.setImage(SystemImages.EDIT_MODE_SELECTION);
        this.modeSelection.addSelectionListener(TuxGuitar.instance().getAction(SetMouseModeSelectionAction.NAME));        
        
        this.modeEdition = new ToolItem(toolBar, SWT.RADIO);
        this.modeEdition.setImage(SystemImages.EDIT_MODE_EDITION);
        this.modeEdition.addSelectionListener(TuxGuitar.instance().getAction(SetMouseModeEditionAction.NAME));        
        
        this.notNaturalKey = new ToolItem(toolBar, SWT.CHECK);
        this.notNaturalKey.setImage(SystemImages.EDIT_MODE_EDITION_NO_NATURAL);
        this.notNaturalKey.addSelectionListener(TuxGuitar.instance().getAction(SetNaturalKeyAction.NAME));  
        
        this.loadProperties();
    }
    
    
    public void update(){
        this.undo.setEnabled(getEditor().getUndoManager().canUndo());
        this.redo.setEnabled(getEditor().getUndoManager().canRedo());
        this.modeSelection.setSelection(getEditor().getTablature().getEditorKit().getMouseMode() == EditorKit.MOUSE_MODE_SELECTION);
        this.modeEdition.setSelection(getEditor().getTablature().getEditorKit().getMouseMode() == EditorKit.MOUSE_MODE_EDITION);
        this.notNaturalKey.setSelection(!getEditor().getTablature().getEditorKit().isNatural());
        this.notNaturalKey.setEnabled(getEditor().getTablature().getEditorKit().getMouseMode() == EditorKit.MOUSE_MODE_EDITION);        
    }
    
    public void loadProperties(){
        this.undo.setToolTipText(TuxGuitar.getProperty("edit.undo"));  
        this.redo.setToolTipText(TuxGuitar.getProperty("edit.redo"));  
    	this.modeSelection.setToolTipText(TuxGuitar.getProperty("edit.mouse-mode-selection"));
    	this.modeEdition.setToolTipText(TuxGuitar.getProperty("edit.mouse-mode-edition"));
    	this.notNaturalKey.setToolTipText(TuxGuitar.getProperty("edit.not-natural-key"));        
    }        
}

