/*
 * Created on 20-mar-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.mixer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class SongMixer {	
	private Shell dialog;
	private SongManager manager;
	private Button metronome;
	private Scale volumeScale;
	private Text volumeText;
	private Label volumeLabel;	
	private List trackMixers;	
	
	public static void main(String[] s) {
		new SongMixer();
	}

	public SongMixer() {
		this.manager = TuxGuitar.instance().getSongManager();
		this.trackMixers = new ArrayList();
	}

	public void show() {
		Shell shell = TuxGuitar.instance().getTablatureEditor().getTablature().getShell();
		this.dialog = new Shell(shell, SWT.DIALOG_TRIM);		
		this.loadData();
		this.dialog.setLocation(getLocation(shell));
		this.dialog.open();
		TuxGuitar.instance().updateCache(true);
		while (!dialog.isDisposed()) {
			if (!dialog.getDisplay().readAndDispatch()) {
				dialog.getDisplay().sleep();
			}
		}		
		TuxGuitar.instance().updateCache(true);
	}
	
	private Point getLocation(Shell parent){
		int x = parent.getBounds().x + (parent.getBounds().width - dialog.getSize().x) / 2;
		int y = parent.getBounds().y + (parent.getBounds().height - dialog.getSize().y) / 2;
		return new Point(x,y);
	}
	
	public void update(){
		if(!isDisposed()){
			this.clear();
			this.loadData();
			this.dialog.layout();
		}
	}
		
	private void loadData(){		
		this.trackMixers.clear();
		List tracks = TuxGuitar.instance().getTablatureEditor().getSongManager().getSong().getTracks();
		Iterator it = tracks.iterator();
		while (it.hasNext()) {
			SongTrack track = (SongTrack) it.next();
			TrackMixer trackMixer = new TrackMixer(this,track);
			trackMixer.init(dialog);
			trackMixers.add(trackMixer);
		}
		Composite composite = new Composite(this.dialog, SWT.NONE);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(SWT.CENTER,SWT.FILL,true,true));
				
		this.metronome = new Button(composite, SWT.TOGGLE);
		this.metronome.setImage(SystemImages.MIXER_METRONOME);
		this.metronome.setSelection(TuxGuitar.instance().getPlayer().isMetronomeEnabled());
		this.metronome.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TuxGuitar.instance().getPlayer().setMetronomeEnabled(metronome.getSelection());
			}		
		});
		
		this.volumeLabel = new Label(composite, SWT.NULL);
		
		this.volumeScale = new Scale(composite, SWT.VERTICAL);
		this.volumeScale.setMaximum(10);
		this.volumeScale.setMinimum(0);
		this.volumeScale.setIncrement(1);
		this.volumeScale.setPageIncrement(1);		
		this.volumeScale.setLayoutData(new GridData(SWT.CENTER,SWT.FILL,true,true));
		
		this.volumeText = new Text(composite, SWT.BORDER | SWT.SINGLE | SWT.CENTER);		
		this.volumeText.setEditable(false);
		this.volumeText.setLayoutData(getVolumeTextData());

		this.volumeScale.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				manager.getSong().setVolume((short)(volumeScale.getMaximum() - volumeScale.getSelection()));
				volumeScale.setToolTipText(TuxGuitar.getProperty("song.volume") + ": " + manager.getSong().getVolume());
				volumeText.setText(Integer.toString(volumeScale.getMaximum() - volumeScale.getSelection()));
				if (TuxGuitar.instance().getPlayer().isRunning()) {
					TuxGuitar.instance().getPlayer().updateControllers();
				}				
			}
		});

		this.volumeScale.setSelection(this.volumeScale.getMaximum() - this.manager.getSong().getVolume());
		this.volumeText.setText(Integer.toString(this.volumeScale.getMaximum() - this.volumeScale.getSelection()));
				
		this.loadProperties();		
		this.dialog.setLayout(new GridLayout(dialog.getChildren().length, false));
		this.dialog.pack();		
	}
	
	private GridData getVolumeTextData(){
		GridData data = new GridData(SWT.CENTER,SWT.NONE,true,false);		
		data.minimumWidth = 40;		
		return data;
	}
	
	private void clear(){
        Control[] controls = dialog.getChildren();
        for(int i = 0;i < controls.length;i++){
            controls[i].dispose();
        }
	}
	
	public void dispose() {
		if(!isDisposed()){
			this.dialog.dispose();
		}
	}

	public boolean isDisposed() {
		return (this.dialog == null || this.dialog.isDisposed());
	}

	public void fireChanges(SongChannel channel){
		Iterator it = this.trackMixers.iterator();
		while(it.hasNext()){
			TrackMixer mixer = (TrackMixer)it.next();
			if(mixer.getTrack().getChannel().getChannel() == channel.getChannel()){
				mixer.getTrack().getChannel().setVolume(channel.getVolume());
				mixer.getTrack().getChannel().setBalance(channel.getBalance());
				mixer.getTrack().getChannel().setChorus(channel.getChorus());
				mixer.getTrack().getChannel().setReverb(channel.getReverb());
				mixer.getTrack().getChannel().setPhaser(channel.getPhaser());
				mixer.getTrack().getChannel().setTremolo(channel.getTremolo());			
				mixer.fireChanges();
			}
		}
		if (TuxGuitar.instance().getPlayer().isRunning()) {
			TuxGuitar.instance().getPlayer().updateControllers();			
		}		
	}

	
	public void loadProperties(){
		if(!isDisposed()){
			Iterator it = this.trackMixers.iterator();
			while(it.hasNext()){
				TrackMixer mixer = (TrackMixer)it.next();
				mixer.loadProperties();
			}
			this.volumeLabel.setText(TuxGuitar.getProperty("song.volume") + ":");
			this.volumeScale.setToolTipText(TuxGuitar.getProperty("song.volume") + ": " + manager.getSong().getVolume());
			this.metronome.setToolTipText(TuxGuitar.getProperty("metronome"));
			
			this.dialog.layout();
		}
	}
	
}
