package org.herac.tuxguitar.gui.system.config.items;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.ConfigKeys;
import org.herac.tuxguitar.gui.system.config.ConfigEditor;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;

public class SoundOption extends Option{
	private Button useDefaultSoundbank;
	private Button useCustomSoundbank;
	private Text fileText;
	private Button fileButton;
	
    public SoundOption(ConfigEditor configEditor,ToolBar toolBar,final Composite parent){
        super(configEditor,toolBar,parent,TuxGuitar.getProperty("settings.config.sound"));
    }
    
    public void createOption(){		
		getToolItem().setText(TuxGuitar.getProperty("settings.config.sound"));	
		getToolItem().setImage(SystemImages.OPTION_SOUND);
		getToolItem().addSelectionListener(this);
		
		showLabel(getComposite(),SWT.FILL | SWT.LEFT | SWT.WRAP,SWT.BOLD,0,TuxGuitar.getProperty("settings.config.sound.soundbank"));    		

		Composite composite = new Composite(getComposite(),SWT.NONE);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(getTabbedData());			
		
		useDefaultSoundbank = new Button(composite,SWT.RADIO); 
		useDefaultSoundbank.setText(TuxGuitar.getProperty("settings.config.sound.default-soundbank"));	    		    
		
		useCustomSoundbank = new Button(composite,SWT.RADIO); 
		useCustomSoundbank.setText(TuxGuitar.getProperty("settings.config.sound.custom-soundbank"));    		
		    		
		Composite chooser = new Composite(composite,SWT.NONE);
		chooser.setLayout(new GridLayout(2,false));

		fileText = new Text(chooser,SWT.BORDER);
		fileText.setLayoutData(new GridData(MINIMUN_WIDTH,SWT.DEFAULT));
		
		fileButton = new Button(chooser,SWT.PUSH);
		fileButton.setImage(SystemImages.OPEN_IMAGE);
		fileButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				String fileName = FileChooser.instance().open(getShell(),FileChooser.ALL_FORMAT/*,null*/);
				if(fileName != null){
					fileText.setText(fileName);
					showRestartMessage();
				}
			}		
		});
		
		useDefaultSoundbank.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(useDefaultSoundbank.getSelection()){
					fileText.setEnabled(false);
					fileButton.setEnabled(false);					
					showRestartMessage();
				}
			}		
		});
		useCustomSoundbank.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if(useCustomSoundbank.getSelection()){
					fileText.setEnabled(true);
					fileButton.setEnabled(true);
				}
			}		
		});
		
		boolean useCustom = getConfig().getBooleanConfigValue(ConfigKeys.SOUNDBANK_CUSTOM);
		useDefaultSoundbank.setSelection(!useCustom);
		useCustomSoundbank.setSelection(useCustom);
		fileText.setEnabled(useCustom);
		fileButton.setEnabled(useCustom);
		if(useCustom){
			fileText.setText(getConfig().getStringConfigValue(ConfigKeys.SOUNDBANK_CUSTOM_PATH));	
		}
    }                        
    
    
    private void showRestartMessage(){
		String title = TuxGuitar.getProperty("warning");
		String message = TuxGuitar.getProperty("settings.config.sound.soundbank-restart-message");
		new MessageDialog(title,message,SWT.ICON_INFORMATION).show(getShell());
    }
    
    public void updateConfig(){
    	boolean useCustom = useCustomSoundbank.getSelection();
    	getConfig().setProperty(ConfigKeys.SOUNDBANK_CUSTOM,useCustom);
    	if(useCustom){
    		getConfig().setProperty(ConfigKeys.SOUNDBANK_CUSTOM_PATH,fileText.getText());	
    	}else{
    		getConfig().removeProperty(ConfigKeys.SOUNDBANK_CUSTOM_PATH);
    	}
    }
   
    public void applyConfig(boolean force){
    }
}