package org.herac.tuxguitar.gui.system.keybindings;

import java.util.HashMap;
import java.util.Map;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.duration.ChangeDottedDurationAction;
import org.herac.tuxguitar.gui.actions.duration.ChangeTupletoDurationAction;
import org.herac.tuxguitar.gui.actions.edit.RedoAction;
import org.herac.tuxguitar.gui.actions.edit.UndoAction;
import org.herac.tuxguitar.gui.actions.file.NewFileAction;
import org.herac.tuxguitar.gui.actions.file.OpenFileAction;
import org.herac.tuxguitar.gui.actions.file.SaveFileAction;
import org.herac.tuxguitar.gui.actions.note.DecrementNoteSemitoneAction;
import org.herac.tuxguitar.gui.actions.note.IncrementNoteSemitoneAction;
import org.herac.tuxguitar.gui.actions.note.ShiftNoteDownAction;
import org.herac.tuxguitar.gui.actions.note.ShiftNoteUpAction;
import org.herac.tuxguitar.gui.actions.player.PlaySongAction;

public class KeyBindingDefaults {
	
	public static Map getDefaultKeyBindings(){
		Map keyBindings = new HashMap();
		//Save File: Ctrl + S
		keyBindings.put(new KeyBinding(115,SpecialKeys.CTRL),TuxGuitar.instance().getAction(SaveFileAction.NAME));
		
		//Open File: Ctrl + W	
		keyBindings.put(new KeyBinding(119,SpecialKeys.CTRL),TuxGuitar.instance().getAction(OpenFileAction.NAME));
		
		//New File: Alt + Ctrl + N	
		keyBindings.put(new KeyBinding(110,SpecialKeys.ALT | SpecialKeys.CTRL),TuxGuitar.instance().getAction(NewFileAction.NAME));	
		
		//Undo: Ctrl + Z			
		keyBindings.put(new KeyBinding(122,SpecialKeys.CTRL),TuxGuitar.instance().getAction(UndoAction.NAME));
		
		//Redo: Ctrl + Y				 
		keyBindings.put(new KeyBinding(121,SpecialKeys.CTRL),TuxGuitar.instance().getAction(RedoAction.NAME));
		
		//Play-Pause: Space		
		keyBindings.put(new KeyBinding(SpecialKeys.SPACE,0),TuxGuitar.instance().getAction(PlaySongAction.NAME));
				
		//Dotted Duration: '*'
		keyBindings.put(new KeyBinding(SpecialKeys.KEYPAD_MULTIPLY,0),TuxGuitar.instance().getAction(ChangeDottedDurationAction.NAME));

		//Dotted Duration: '.'
		keyBindings.put(new KeyBinding(SpecialKeys.KEYPAD_DECIMAL,0),TuxGuitar.instance().getAction(ChangeDottedDurationAction.NAME));
		
		//Tupleto Duration: '/'
		keyBindings.put(new KeyBinding(SpecialKeys.KEYPAD_DIVIDE,0),TuxGuitar.instance().getAction(ChangeTupletoDurationAction.NAME));
		
		//Shift Up:  'SHIFT + UP'
		keyBindings.put(new KeyBinding(SpecialKeys.UP,SpecialKeys.SHIFT),TuxGuitar.instance().getAction(ShiftNoteUpAction.NAME));
		
		//Shift Up:  'SHIFT + DOWN'
		keyBindings.put(new KeyBinding(SpecialKeys.DOWN,SpecialKeys.SHIFT),TuxGuitar.instance().getAction(ShiftNoteDownAction.NAME));
		
		//Increment semitone: 'SHIFT + RIGHT'
		keyBindings.put(new KeyBinding(SpecialKeys.RIGHT,SpecialKeys.SHIFT),TuxGuitar.instance().getAction(IncrementNoteSemitoneAction.NAME));
		
		//Decrement semitone: 'SHIFT + LEFT'
		keyBindings.put(new KeyBinding(SpecialKeys.LEFT,SpecialKeys.SHIFT),TuxGuitar.instance().getAction(DecrementNoteSemitoneAction.NAME));
				
		
		return keyBindings;
	}
}
