package org.herac.tuxguitar.gui.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;

import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintPage;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfWriter;

public class PDFWriter {
	
	public static void write(String fileName,PrintDocument printDocument) {
		try {
			write(new FileOutputStream(fileName),printDocument);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
	}
	
	public static void write(OutputStream out,PrintDocument printDocument) {
		Document document = new Document();
		try {			
			PdfWriter.getInstance(document,out);			
			document.open();						
			Iterator it = printDocument.getPages().iterator();
			while(it.hasNext()){
				PrintPage page = (PrintPage)it.next();								
				document.newPage();	
				document.add(ImageUtils.convertToIText(page.getData()));
			}
		} catch (DocumentException de) {
			System.err.println(de.getMessage());
		}
		document.close();
	}
	
}
