/*
 * Created on 26-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.models.effects.BendEffect;
import org.herac.tuxguitar.song.models.effects.GraceEffect;
import org.herac.tuxguitar.song.models.effects.HarmonicEffect;
import org.herac.tuxguitar.song.models.effects.TremoloBarEffect;
import org.herac.tuxguitar.song.models.effects.TremoloPickingEffect;
import org.herac.tuxguitar.song.models.effects.TrillEffect;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class NoteEffect {
        
    private BendEffect bend;
    private TremoloBarEffect tremoloBar;
    private HarmonicEffect harmonic;
    private GraceEffect grace;
    private TrillEffect trill;
    private TremoloPickingEffect tremoloPicking;
    private boolean vibrato;
    private boolean deadNote;
    private boolean slide;
    private boolean hammer;    
    private boolean ghostNote;
    private boolean accentuatedNote;
    private boolean heavyAccentuatedNote;
    private boolean palmMute;
    private boolean staccato;    
    private boolean tapping;
    private boolean slapping;
    private boolean popping;    
    private boolean fadeIn;
    
    private NoteEffect(BendEffect bend,
    				   TremoloBarEffect tremoloBar,
    				   HarmonicEffect harmonic,
    				   GraceEffect grace,
    				   TrillEffect trill,
    				   TremoloPickingEffect tremoloPicking,
    				   boolean vibrato,
    				   boolean deadNote,
    				   boolean slide,
    				   boolean hammer,
    				   boolean ghostNote,
    				   boolean accentuatedNote,
    				   boolean heavyAccentuatedNote,
    				   boolean palmMute,
    				   boolean staccato,
    				   boolean tapping,
    				   boolean slapping,
    				   boolean popping,
    				   boolean fadeIn){                
        this.bend = bend;       
        this.tremoloBar = tremoloBar;
        this.harmonic = harmonic;
        this.grace = grace;
        this.trill = trill;
        this.tremoloPicking = tremoloPicking;
        this.vibrato = vibrato;      
        this.deadNote = deadNote;        
        this.slide = slide;
        this.hammer = hammer;
        this.ghostNote = ghostNote;
        this.accentuatedNote = accentuatedNote;
        this.heavyAccentuatedNote = heavyAccentuatedNote;
        this.palmMute = palmMute;
        this.staccato = staccato;
        this.tapping = tapping;
        this.slapping = slapping;
        this.popping = popping;
        this.fadeIn = fadeIn;
    }    
    
    public NoteEffect(){        
        this(null,null,null,null,null,null,false,false,false,false,false,false,false,false,false,false,false,false,false);
    }  
    
    public boolean isDeadNote() {
		return deadNote;
	}

	public void setDeadNote(boolean deadNote) {
		this.deadNote = deadNote;
        //si es true, quito los efectos incompatibles
        if(this.isDeadNote()){     
        	this.tremoloBar = null;
        	this.bend = null;
        	this.trill = null;
        	this.slide = false;
            this.hammer = false;                    	
        }       		
	}
    
    public boolean isVibrato() {
        return vibrato;
    }
    public void setVibrato(boolean vibrato) {
        this.vibrato = vibrato;
        //si no es null quito los efectos incompatibles
        if(this.isVibrato()){
        	this.trill = null;
        }
    }        
    
    public BendEffect getBend() {
        return bend;
    }
    
    public void setBend(BendEffect bend) {
        this.bend = bend;
        //si no es null quito los efectos incompatibles
        if(this.isBend()){        
        	this.tremoloBar = null;
        	this.trill = null;
        	this.deadNote = false;
            this.slide = false;
            this.hammer = false;              
        }
    }
    
    public boolean isBend() {
        return (bend != null && !bend.getPoints().isEmpty());
    }
    
	public TremoloBarEffect getTremoloBar() {
		return tremoloBar;
	}

	public void setTremoloBar(TremoloBarEffect tremoloBar) {
		this.tremoloBar = tremoloBar;
        //si no es null quito los efectos incompatibles
        if(this.isTremoloBar()){
        	this.bend = null;
        	this.trill = null;
        	this.deadNote = false;
            this.slide = false;
            this.hammer = false;              
        }		
	}
	
    public boolean isTremoloBar() {
        return (tremoloBar != null);
    }
    

	public TrillEffect getTrill() {
		return trill;
	}

	public void setTrill(TrillEffect trill) {
		this.trill = trill;
        //si es true, quito los efectos incompatibles
        if(this.isTrill()){        	
        	this.bend = null;
        	this.tremoloBar = null;
        	this.tremoloPicking = null;
        	this.slide = false;
            this.hammer = false;  
            this.deadNote = false; 
            this.vibrato = false;
        }   		
	}    
    
	public boolean isTrill() {
		return (trill != null);
	}
	
	
	
    public TremoloPickingEffect getTremoloPicking() {
		return tremoloPicking;
	}

	public void setTremoloPicking(TremoloPickingEffect tremoloPicking) {
		this.tremoloPicking = tremoloPicking;
        //si es true, quito los efectos incompatibles
        if(this.isTremoloPicking()){        	
        	this.trill = null;
        	this.bend = null;
        	this.tremoloBar = null;
        	this.slide = false;
            this.hammer = false;  
            this.deadNote = false; 
            this.vibrato = false;
        }  		
	}
	
	public boolean isTremoloPicking() {
		return (tremoloPicking != null);
	}

	public boolean isHammer() {
        return hammer;
    }
    
    public void setHammer(boolean hammer) {
        this.hammer = hammer;   
        //si es true, quito los efectos incompatibles
        if(this.isHammer()){      
        	this.trill = null;
        	this.tremoloBar = null;
        	this.bend = null;
        	this.deadNote = false;
            this.slide = false;                    	
        }        
    }
    
    public boolean isSlide() {
        return slide;
    }
    
    public void setSlide(boolean slide) {
        this.slide = slide;
        //si es true, quito los efectos incompatibles
        if(this.isSlide()){     
        	this.trill = null;
        	this.tremoloBar = null;
        	this.bend = null;
        	this.deadNote = false;
            this.hammer = false;                    	
        }             
    }
    

	public boolean isGhostNote() {
		return ghostNote;		
	}

	public void setGhostNote(boolean ghostNote) {
		this.ghostNote = ghostNote;
        //si es true, quito los efectos incompatibles
        if(this.isGhostNote()){
        	this.accentuatedNote = false;
        	this.heavyAccentuatedNote = false;       	
        }   
	}    
    
    public boolean isAccentuatedNote() {
		return accentuatedNote;
	}

	public void setAccentuatedNote(boolean accentuatedNote) {
		this.accentuatedNote = accentuatedNote;
        //si es true, quito los efectos incompatibles
        if(this.isAccentuatedNote()){
        	this.ghostNote = false;
        	this.heavyAccentuatedNote = false;       	
        }   		
	}


	public boolean isHeavyAccentuatedNote() {
		return heavyAccentuatedNote;
	}

	public void setHeavyAccentuatedNote(boolean heavyAccentuatedNote) {
		this.heavyAccentuatedNote = heavyAccentuatedNote;
        //si es true, quito los efectos incompatibles
        if(this.isHeavyAccentuatedNote()){
        	this.ghostNote = false;
        	this.accentuatedNote = false;       	
        }   			
	}
    
    public void setHarmonic(HarmonicEffect harmonic) {
        this.harmonic = harmonic;
    }
    
    public HarmonicEffect getHarmonic() {
        return this.harmonic;
    }
    
    
    public boolean isHarmonic() {
        return (harmonic != null);
    }
        
    public GraceEffect getGrace() {
		return grace;
	}

	public void setGrace(GraceEffect grace) {
		this.grace = grace;
	}
	
    public boolean isGrace() {
		return (grace != null);
	}
        
	public boolean isPalmMute() {
		return palmMute;
	}

	public void setPalmMute(boolean palmMute) {
		this.palmMute = palmMute;
        //si es true, quito los efectos incompatibles
        if(this.isPalmMute()){
        	this.staccato = false;   	
        }  		
	}


	public boolean isStaccato() {
		return staccato;
	}

	public void setStaccato(boolean staccato) {
		this.staccato = staccato;
        //si es true, quito los efectos incompatibles
        if(this.isStaccato()){
        	this.palmMute = false;   	
        }  				
	}

	
	
	public boolean isPopping() {
		return popping;
	}

	public void setPopping(boolean popping) {
		this.popping = popping;
        //si es true, quito los efectos incompatibles
        if(this.isPopping()){
        	this.tapping = false;
        	this.slapping = false;
        }  					
	}

	public boolean isSlapping() {
		return slapping;
	}

	public void setSlapping(boolean slapping) {
		this.slapping = slapping;
        //si es true, quito los efectos incompatibles
        if(this.isSlapping()){
        	this.tapping = false;
        	this.popping = false;
        }  				
	}

	public boolean isTapping() {
		return tapping;
	}

	public void setTapping(boolean tapping) {
		this.tapping = tapping;
        //si es true, quito los efectos incompatibles
        if(this.isTapping()){
        	this.slapping = false;
        	this.popping = false;
        }  		
	}

	
	
	public boolean isFadeIn() {
		return fadeIn;
	}

	public void setFadeIn(boolean fadeIn) {
		this.fadeIn = fadeIn;
	}
	
	

    public boolean hasAnyEffect(){
    	  return (isBend() ||
    			  isTremoloBar() ||
    			  isHarmonic() ||
    			  isGrace() ||
    			  isTrill() ||
    			  isTremoloPicking() ||
    			  isVibrato() ||
    			  isDeadNote() ||
    			  isSlide() ||
    			  isHammer() ||
    			  isGhostNote() ||
    			  isAccentuatedNote() ||
    			  isHeavyAccentuatedNote() ||
    			  isPalmMute() ||
    			  isStaccato() ||
    			  isTapping() ||
    			  isSlapping() ||
    			  isPopping() ||
    			  isFadeIn());    	
    }

	public Object clone(){
        BendEffect bend = null;
        if(isBend()){
            bend = (BendEffect)this.bend.clone();
        }
        TremoloBarEffect tremoloBar = null;
        if(isTremoloBar()){
        	tremoloBar = (TremoloBarEffect)this.tremoloBar.clone();
        }        
        HarmonicEffect harmonic = null;
        if(isHarmonic()){
        	harmonic = (HarmonicEffect)this.harmonic.clone();
        }
        GraceEffect grace = null;
        if(isGrace()){
        	grace = (GraceEffect)this.grace.clone();
        }
        TrillEffect trill = null;
        if(isTrill()){
        	trill = (TrillEffect)this.trill.clone();
        }        
        
        TremoloPickingEffect tremoloPicking = null;
        if(isTremoloPicking()){
        	tremoloPicking = (TremoloPickingEffect)this.tremoloPicking.clone();
        }              
        
        return new NoteEffect(bend,
        					  tremoloBar,
        					  harmonic,
        					  grace,
        					  trill,
        					  tremoloPicking,
        					  isVibrato(),
        					  isDeadNote(),
        					  isSlide(),
        					  isHammer(),
        					  isGhostNote(),
        					  isAccentuatedNote(),
        					  isHeavyAccentuatedNote(),
        					  isPalmMute(),
        					  isStaccato(),
        					  isTapping(),
        					  isSlapping(),
        					  isPopping(),
        					  isFadeIn());
    }
}
