package org.herac.tuxguitar.song.models;

public class RGBColor {
	public static final RGBColor RED = new RGBColor(255,0,0);
	public static final RGBColor GREEN = new RGBColor(0,255,0);
	public static final RGBColor BLUE = new RGBColor(0,0,255);
	public static final RGBColor WHITE = new RGBColor(255,255,255);
	public static final RGBColor BLACK = new RGBColor(0,0,0);
	
	private int r;
	private int g;
	private int b;
	
	public RGBColor(int r,int g,int b){
		this.r = r;
		this.g = g;
		this.b = b;
	}
	
	public int getB() {
		return b;
	}

	public void setB(int b) {
		this.b = b;
	}

	public int getG() {
		return g;
	}

	public void setG(int g) {
		this.g = g;
	}

	public int getR() {
		return r;
	}

	public void setR(int r) {
		this.r = r;
	}
	
	public boolean isEqual(RGBColor color){
		return (this.getR() == color.getR() && this.getG() == color.getG() && this.getB() == color.getB());
	}
	
	public Object clone(){
	    return new RGBColor(getR(),getG(),getB());
	}
	
}
