package org.herac.tuxguitar.song.models.effects;

import org.herac.tuxguitar.song.models.Duration;

public class TrillEffect {
	
	private int fret;			
	private Duration duration;
	
	public TrillEffect(int fret, int value) {
		this(fret,new Duration(value));
	}
	
	public TrillEffect(int fret, Duration duration) {
		this.fret = fret;
		this.duration = duration;
	}

	public int getFret() {
		return fret;
	}

	public void setFret(int fret) {
		this.fret = fret;
	}	
	
	public Duration getDuration() {
		return duration;
	}

	public void setDuration(Duration duration) {
		this.duration = duration;
	}
	
	public Object clone(){
		return new TrillEffect(fret,getDuration().getValue());
	}
}
