package org.herac.tuxguitar.song.util;

import java.util.ArrayList;
import java.util.List;

import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.InstrumentString;

public class NoteMaker {
	private static final int MAX_DISTANCE = 4;
	
	public static void main(String[] s){
		new NoteMaker();
		System.exit(0);
	}
	
	public NoteMaker(){		
		int[] values = new int[]{69,79,56,52,47,40};	
		getStringsForValues(SongManager.createDefaultInstrumentStrings(),values);		
	}
	
	
	public void getStringsForValues(List strings,int[] values){
		List tempStrings = new ArrayList();
		tempStrings.addAll(strings);
					
		for(int i = 0;i < values.length;i ++){
			int string = getStringForValue(tempStrings,values[i]);
			for(int j = 0;j < tempStrings.size();j ++){
				InstrumentString tempString = (InstrumentString)tempStrings.get(j);	
				if(tempString.getNumber() == string){
					tempStrings.remove(j);
					break;
				}
			}
		}
		
	}

	public int getStringForValue(List strings,int value){
		int minFret = -1;
		int stringForValue = 0;
		for(int i = 0;i < strings.size();i++){
			InstrumentString string = (InstrumentString)strings.get(i);						
			int fret = value - string.getValue();			
			if(minFret < 0 || (fret >= 0 && fret < minFret)){
				stringForValue = string.getNumber();
				minFret = fret;				
			}
		}		
		
		System.out.println("String: " + stringForValue + " Fret: " + minFret + " ");		
		
		
		return stringForValue;
	}
}


