#!/bin/bash
#
# dm-config-mx.sh
#
#    Create config file for X. (userful.Mxorg.conf)
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
#
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

# source lib functions
source /opt/userful/bin/userful-bash-lib.sh

PATH=$PATH:/usr/X11R6/bin/

CPUTYPE=
CARDNAME=
DUALVIEW=0

TOUCHSCREEN=5
DEVTYPE=
VENDORID=
PRODUCTID=
NUM_OF_TOUCH=0

ELOTOUCH=04E7
MITOUCH=0596

OSNAME=
OSVER=
MXVER=
X_CONFIGURE=
XSERVER=

# it is used to be userful.xorg.conf.all
X_CONFIG_FILE="userful.xorg.conf.one"

# find available lspci command.
if which lspci > /dev/null 2>&1; then
	LSPCI="lspci"
else
	LSPCI="/opt/userful/bin/listpci"
fi
BUSID_LEN=`$LSPCI -n | grep -m 1 "0300: " | cut -d ' ' -f 1 | wc -m`


###
# Check number of DualView capable cards
###
check_dualview()
{
	$LSPCI -n | grep "0300: " > /tmp/videolist.tmp

	while read VIDEOENTRY; do
		if echo $VIDEOENTRY | tr "[A-Z]" "[a-z]" | grep class > /dev/null 2>&1 ; then
			DEVID=`echo $VIDEOENTRY | awk -- '{print $4}'`
		else
			DEVID=`echo $VIDEOENTRY | awk -- '{print $3}'`
		fi

		if grep "$DEVID" /opt/userful/bin/VGAINFO > /dev/null ; then
			CARDTYPE=`grep "$DEVID" /opt/userful/bin/VGAINFO | awk -- '{print $3}'`
			if [ "$CARDTYPE" == "D" ]; then
				DUALVIEW=$(( $DUALVIEW + 1 ))
			fi
		fi
	done < /tmp/videolist.tmp
}


###
# check if current system is Laptop computer
###
check_laptop()
{
	TMPSTR=`$LSPCI -n | grep -c "0300: "`
	if [ "$TMPSTR" == "1" ]; then  # laptop has only one graphic card entity
		TMPSTR=`$LSPCI -n | grep "0300: "`

		if echo $TMPSTR | tr "[A-Z]" "[a-z]" | grep class > /dev/null 2>&1 ; then
			# has "Class" string in the lspci -n
        	VENDORID=`echo $TMPSTR | awk '{split($4,a,":"); print a[1]}'`
        	VIDEOID=`echo $TMPSTR | awk '{split($4,a,":"); print a[2]}'`
		else
			# doesn't has "Class" string in the lspci -n
        	VENDORID=`echo $TMPSTR | awk '{split($3,a,":"); print a[1]}'`
        	VIDEOID=`echo $TMPSTR | awk '{split($3,a,":"); print a[2]}'`
		fi

		CARDNAME=`grep "0x"$VENDORID /etc/userful/pcitable |
				   grep "0x"$VIDEOID |
				   awk -- '{if(substr($3,2,4) == "Card") {split($0,a,"\""); print a[2]}}' |
				   awk -- '{split($0,b,":"); print b[2]}'`

        # Graphics card for laptop has following strings in it's product name.
		if echo $CARDNAME | tr "[A-Z]" "[a-z]" | grep " mobility" > /dev/null 2>&1 || \
		   echo $CARDNAME | tr "[A-Z]" "[a-z]" | grep " igp" > /dev/null 2>&1 || \
		   echo $CARDNAME | tr "[A-Z]" "[a-z]" | grep " go" > /dev/null 2>&1 ; then
		   CPUTYPE=`grep -m 1 "model name" /proc/cpuinfo |
				    awk -- '{split($0,a,":"); print a[2]}'`
	   fi
	fi
}

###
# - Check if there is touchscreen device in the system
# - Assumes that any device that has ELOTOUCH and MITOUCH for the Vendor ID 
#   is a Touch screen device
###
function check_touchscreen()
{
	rm -f /tmp/touchscreen-dev
	TOUCH_CNT=0

	## find ELOTOUCH or MITOUCH touch screen.
	while read USBINPUT; do
		if [ "${USBINPUT:0:1}" == "I" ]; then # Interface
			if  echo $USBINPUT | tr "a-z" "A-Z" | grep "VENDOR=$ELOTOUCH" > /dev/null 2>&1 || \
				echo $USBINPUT | tr "a-z" "A-Z" | grep "VENDOR=$MITOUCH" > /dev/null 2>&1; then
				# found Elo touch or Mi touch device
				NUM_OF_TOUCH=$(( $NUM_OF_TOUCH + 1 ))
				TOUCH_CNT=1
			fi
		elif [ "${USBINPUT:0:1}" == "N" -a $TOUCH_CNT -eq 1 ]; then # Name
			if echo $USBINPUT | tr "a-z" "A-Z" | grep "NAME=" > /dev/null 2>&1 ; then
				echo $USBINPUT | awk -F'=' -- '{print $2}' | tr -d "\"" >> /tmp/touchscreen-dev
				TOUCH_CNT=0
			fi
		fi
	done < /proc/bus/input/devices

	## find other touchscreens listed in /opt/userful/bin/USBINPUTTABLE
	while read USBDEV; do
		if ! echo $USBDEV | grep "^[[:space:]]*#" > /dev/null 2>&1 && \
			[ ${#USBDEV} -ne 0 ]; then
			VENDORID=`echo $USBDEV | awk -- '{print $1}'`
			PRODUCTID=`echo $USBDEV | awk -- '{print $2}'`
			DEVTYPE=`echo $USBDEV | awk -- '{print $3}'`

			if [ $DEVTYPE -eq $TOUCHSCREEN ] &&
				[ "$VENDORID" != "$ELOTOUCH" -a "$VENDORID" != "$MITOUCH" ]; then

				# number of current touchscreen device
				CNT=`grep -i "Vendor=$VENDORID Product=$PRODUCTID" /proc/bus/input/devices | wc -l`

				if [ $CNT -gt 0 ]; then
					# get the name of current touchscreen
					grep -i -A 1 "Vendor=$VENDORID Product=$PRODUCTID" /proc/bus/input/devices | \
							grep "N:" | awk -F'"' -- '{print $2}' >> /tmp/touchscreen-dev

					NUM_OF_TOUCH=$(( $NUM_OF_TOUCH + $CNT ))
				fi

			fi
		fi
	done < /opt/userful/bin/USBINPUTTABLE

    if [ -e /tmp/touchscreen-dev ]; then
	    cat /tmp/touchscreen-dev >>  $logfile
    fi
}

#===  FUNCTION  ================================================================
#          NAME:  configure_mx()
#   DESCRIPTION:  Generate X/MX config file. (userful.Mxorg.conf, userful.xorg.conf.one
#                 userful.xorg.conf.all
#    PARAMETERS:  -f (First installation), -n(No config file), -r (reconfiguration)
#       RETURNS:  None
#===============================================================================
function configure_mx()
{
	
	# configure mga driver
	#/opt/userful/bin/dm-config-mga-driver.sh single

    ##
	## initialization
    ##
	rm -f /etc/dm-sys-info
	rm -f /tmp/ret-config-message
    rm -f /etc/userful/X-fail

    #
	# check if the nVidia driver and kernel module exist.
    #
	if $LSPCI -n | tr "a-z" "A-Z" | grep "0300:[[:space:]]10DE:" > /dev/null 2>&1 ; then
	    IS_NVIDIA_DRIVER=$(Check_nVidia_Driver)
        if [[ "$IS_NVIDIA_DRIVER" == "false" ]]; then
	        echo "`date +"%b %d %T"` $ProgramName: nVidia driver and/or kernel module was not found." >> $logfile
        else
	        echo "`date +"%b %d %T"` $ProgramName: Both nVidia card and nVidia driver/kernel module found." >> $logfile
        fi
    fi

    #
	# create xorg.conf.new
    #
    XORG_CONF_NEW=xorg.conf.new
	echo "`date +"%b %d %T"` $ProgramName: Run \"X -configure\" to create $XORG_CONF_NEW " >> $logfile
	rm -f /root/$XORG_CONF_NEW /$XORG_CONF_NEW  2> /dev/null

    #
	# If the system has savage colorgraphics card(s), don't run "X -configure"
	# because X has problem(freezing) with multiple SAVAGE colorgraphics cards (5333:8A22)
	if $LSPCI -n | tr "a-z" "A-Z" | grep "5333:8A22" > /dev/null 2>&1 ; then
		:
	else

        ## Create /tmp/X-start and /tmp/waiting-for-x
        date +%s > /tmp/X-start
        # waiting-for.sh --xorg will be paused until it find /tmp/waiting-for-x file.
        touch /tmp/waiting-for-x

        ## Kill X if it hogs CPU 
        /opt/userful/bin/waiting-for.sh --xorg x &

        # Generate xorg.conf.new with Multi X on new Linux distros. 
        if [ "$X_CONFIGURE" == "multi" ]; then
            /opt/$MXVER/bin/Xorg -configure -logfile /var/log/mx11r7-configure.log
        else
		    $XSERVER -configure -logfile /var/log/mx11r7-configure.log
        fi

        ## Delete /tmp/X-start
        ## X -configure shouldn't take long time
        rm -f /tmp/X-start

		if [[ ! -f /root/$XORG_CONF_NEW ]]; then
			if [[ -f /$XORG_CONF_NEW ]]; then
				cp -f /$XORG_CONF_NEW /root/
            else
                echo "`date +"%b %d %T"` $ProgramName: /root/$XORG_CONF_NEW is not available." >> $logfile
            fi
        fi

        #retval=$?
        #if [[ "$retval" != "0" ]]; then
		#	echo "`date +"%b %d %T"` $ProgramName: Multi-X -configure failed." >> $logfile
        #fi

        ################
        ## Comments out
        ################
        if [ ]; then
		if [[ ! -f /root/$XORG_CONF_NEW ]]; then
			if [[ -f /$XORG_CONF_NEW ]]; then
				cp -f /$XORG_CONF_NEW /root/
			else
                if [ "$X_CONFIGURE" == "multi" ]; then
                    # If Multi X failed to create xorg.conf.new, use Normal X
		            $XSERVER -configure > /dev/null 2>&1
                else
                    /opt/$MXVER/bin/Xorg -configure -logfile /var/log/mx11r7-configure.log
                fi

                if [[ ! -e /root/$XORG_CONF_NEW ]]; then
			        if [[ -f /$XORG_CONF_NEW ]]; then
				        cp -f /$XORG_CONF_NEW /root/
                    else
                        echo "`date +"%b %d %T"` $ProgramName: /root/$XORG_CONF_NEW is not available." >> $logfile
                    fi
                fi
			fi
		fi
        fi  
        ###############
        ## Comment out
        ###############
	fi

    #
	# create userful.xorg.conf.all and userful.xorg.conf.one
	/opt/userful/bin/dm-gen-xconfig.sh -one
	/opt/userful/bin/dm-gen-xconfig.sh -all
	#if [[ -f /root/$XORG_CONF_NEW ]]; then
	#	/opt/userful/bin/dm-gen-xconfig.sh -one
	#	/opt/userful/bin/dm-gen-xconfig.sh -all
	#else
	#	/opt/userful/bin/mx-config-gen.sh -all
	#	/opt/userful/bin/mx-config-gen.sh -one
	#fi

    #
    # Monitor Probing
    if [ -e /tmp/Monitor.Probed ]; then
        rm -f /tmp/Monitor.Probed
    fi
    # umx-probe-monitor will create /tmp/Monitor.Probed file if it succeeds.
    /opt/userful/bin/umx-probe-monitor.pl

    # Find resolution
    if [ -e /tmp/Monitor.Probed ]; then
        PROBED_RES=`grep -m1 "ModeLine" /tmp/Monitor.Probed | awk '{print $2}'`
        if [ -z $PROBED_RES ]; then
            PROBED_RES="none"
        fi
    fi

    if [ x == x"$PROBED_RES" ]; then
        PROBED_RES="none"
    fi

    #
	# create /tmp/sysinfo.tmp for the CPU and VGA information
	/opt/userful/bin/dm-create-sysinfo.sh

    #
	# check if current system is Laptop computer
	check_laptop

	# check if there is TouchScreen device in the system.
	# TouchScreen doesn't support DualView
	check_touchscreen
	#echo "Number of touchscreen: $NUM_OF_TOUCH"
	
    ##
	## check reseller's logo
    ## TODO:
    ##  - This should be updated
	rm -f /opt/userful/images/reseller-logo.jpg

    if [ -x /opt/userful/bin/dm-gen-info ]; then
        /opt/userful/bin/dm-gen-info -licenseinfo -compare
    else
	    /opt/userful/bin/sno-comp
    fi

	source /etc/userful/userful-license-info
	if [ "$RESELLER_LOGO" != "" -a -e /opt/userful/images/reseller/$RESELLER_LOGO.jpg ]; then
		echo "`date +"%b %d %T"` $ProgramName: Use reseller log: $RESELLER_LOGO.jpg" >>  $logfile
		cp -f /opt/userful/images/reseller/$RESELLER_LOGO.jpg /opt/userful/images/reseller-logo.jpg
	fi

    ##
    ## Update X_CONFIG_FILE
    ##  - RgbPath causes X crash with the newer X server
    ##  - Disable option cuases X crash for the older X server
    ##
	if [ -n "$OSNAME" -a -n "$OSVER" ]; then
		if [ "$OSNAME" == "ubuntu" -a "$OSVER" == "8.10" ] || 
	  	   [ "$OSNAME" == "fedora" -a "$OSVER" == "10" ]; then 

           if grep -q "RgbPath" /etc/X11/$X_CONFIG_FILE ; then
               sed -i -e "/RgbPath/d" /etc/X11/$X_CONFIG_FILE
           fi

        else
           sed -i -e "/\<Disable\>/d" /etc/X11/$X_CONFIG_FILE
	    fi
	fi

	# We need to set environment variables for language translation.
	# This could be different for each distro.
	# FC4
	[[ -f /etc/profile.d/lang.sh ]] && source /etc/profile.d/lang.sh
	echo "`date +"%b %d %T"` $ProgramName: LANG=$LANG" >> $logfile

    ##
	## check if config-message program starts properly.
	## Multiple Colorgraphics savage cards causes normal X hung.
    OPT_STR=""
	if [ -n "$CARDNAME" -a -n "$CPUTYPE" ]; then 

        ## Laptop 
        OPT_STR="-cpu \"$CPUTYPE\" $OPT_STR"

		if [ $NUM_OF_TOUCH -gt 0 ]; then
            # TouchScreen
            OPT_STR="-touchscreen \"$NUM_OF_TOUCH\" $OPT_STR"

			if [ "$IS_NVIDIA_DRIVER" == "false" ]; then
                # No nVidia driver
                OPT_STR="-nonvidia $OPT_STR"
			fi
		else
			if [ "$IS_NVIDIA_DRIVER" == "false" ]; then
                # No nVidia driver
                OPT_STR="-nonvidia $OPT_STR"
			fi
            OPT_STR="-monitor \"$PROBED_RES\" $OPT_STR"
		fi

        OPT_STR="-vga \"$CARDNAME\" $OPT_STR"

	elif [ $NUM_OF_TOUCH -gt 0 ]; then # Normal Desktop with touchscreen

        # TouchScreen
        OPT_STR="-touchscreen \"$NUM_OF_TOUCH\" $OPT_STR"

		if [ "$IS_NVIDIA_DRIVER" == "false" ]; then
            OPT_STR="-nonvidia $OPT_STR"
		fi
	else # Normal desktop 
		check_dualview
        # DualView
        OPT_STR="-dualview \"$DUALVIEW\" $OPT_STR"

		if [ "$IS_NVIDIA_DRIVER" == "false" ]; then
            OPT_STR="-nonvidia $OPT_STR"
		fi
        OPT_STR="-monitor \"$PROBED_RES\" $OPT_STR"
	fi

    ##
    ## set "-isolateDevice BUSID" option
    ISOLATEDEVICE=""
    nBUSID=`grep "\<BusID\>" /etc/X11/$X_CONFIG_FILE | wc -l`
    if [ $nBUSID -eq 1 ]; then
        B_ID=`grep "\<BusID\>" /etc/X11/$X_CONFIG_FILE | awk -F"\"" -- '{print $2}'`
        ISOLATEDEVICE="-isolateDevice $B_ID"
    fi

	if [ "$OSNAME" == "novell" -a "$OSVER" == "10" ]; then 
        # X server in Novell 10 doesn't support "-isolateDevice" option
        ISOLATEDEVICE=""
    fi

    ## Create /tmp/X-start and /tmp/waiting-for-x
    date +%s > /tmp/X-start
    # waiting-for.sh --xorg will be paused until it find /tmp/waiting-for-x file.
    touch /tmp/waiting-for-x
    ## Kill X if it hogs CPU 
    /opt/userful/bin/waiting-for.sh --xorg x &

    ## config-message should delete /tmp/X-start
	xinit /opt/userful/bin/config-message $1 $OPT_STR -- $XSERVER -config $X_CONFIG_FILE -br $ISOLATEDEVICE

	RET=`cat /tmp/ret-config-message`
	if [ "$RET" == "1" ]; then
		# use old config file
		echo "`date +"%b %d %T"` $ProgramName: Use old configuration instead of creating new one." >>  $logfile
		$LSPCI -n | grep "0300: " > /etc/X11/vgainfo
		return 0
    fi
	#elif [ $RET -ne 0 ]; then
		# exit from startup procedure
		#echo "`date +"%b %d %T"` $ProgramName: Failed to configure system." >>  $logfile
		#pkill prefdm_multi
		#chvt 2
		#exit 1
	#fi

	###
	# create userful.Mxorg.conf
	###
	rm -f /etc/stations
	rm -f /etc/X11/stations
	rm -f /etc/X11/userful.Mxorg.conf
	rm -f /etc/usbinput
	rm -f /etc/X11/xdm/Xservers
	rm -f /etc/mvgainfo

    if [ -x /opt/userful/bin/dm-gen-info ]; then
        /opt/userful/bin/dm-gen-info -licenseinfo -compare
    else
	    /opt/userful/bin/sno-comp
    fi
	$LSPCI -n | grep "0300: " > /etc/X11/vgainfo

    ##
	## create config files
    ##
	/opt/userful/bin/dm-gen-xconfig.sh -check
	/opt/userful/bin/dm-gen-xconfig.sh -1box
	#if [[ -f /root/$XORG_CONF_NEW ]]; then
	#	/opt/userful/bin/dm-gen-xconfig.sh -check
	#	/opt/userful/bin/dm-gen-xconfig.sh -1box
	#else
	#	pushd /opt/userful/bin > /dev/null
	#		/opt/userful/bin/mx-config-gen.sh -check
	#		/opt/userful/bin/mx-config-gen.sh -1box
   	#	popd > /dev/null
	#fi

    ##
    ## Update userful.Mxorg.conf
    ##  - RgbPath causes X crash with the newer X server
    ##  - Disable in the Module section causes X crash with the older X server
    ##
    if [ -f /etc/X11/userful.Mxorg.conf ]; then
       if [ -f /opt/MX11R7/lib/libpciaccess.so ]; then
           if grep -q "RgbPath" /etc/X11/userful.Mxorg.conf ; then
               sed -i -e "/RgbPath/d" /etc/X11/userful.Mxorg.conf
           fi
       else
           sed -i -e "/\<Disable\>/d" /etc/X11/userful.Mxorg.conf
       fi
   fi

	# Block this for a while
	# create config file for normal X if there isn't any.
	#if [ -x /usr/X11R6/bin/XFree86 ] && [ ! -e /etc/X11/XF86Config ]; then
	#	cp -f /etc/X11/userful.xorg.conf.one /etc/X11/XF86Config
	#
	#elif [ ! -e /etc/X11/xorg.conf ]; then
	#	cp -f /etc/X11/userful.xorg.conf.one /etc/X11/xorg.conf
	#fi

	# There are Touchscreen device. Need to calibrate
	if [ -e /tmp/touchscreen-dev ]; then
		echo "`date +"%b %d %T"` $ProgramName: Calibration procedure starts." >>  $logfile
		/opt/userful/evtouch/calibrate.sh
	fi

    ##
    ## TODO:
    ##  - Reboot system after first configuration
    #telinit 6
    ##
    # Reboot system if required
    #  - Ubuntu 8.10 
    #if [ -f /etc/mvgainfo ]; then
    #    nCards=`cat /etc/mvgainfo | wc -l`
    #else
    #    nCards=0
    #fi
    #if [ "$OSNAME" == "ubuntu" -a "$OSVER" == "8.10" ] ; then
    #    if [ $nCards -ne 1 ]; then
	#	    telinit 6
    #    fi
    #fi 
    if [ -e /etc/userful/X-fail ]; then
	    telinit 6
    fi

	# reboot if Matrox Card exists  -- Not anymore.
	#$LSPCI -n | grep "0300: " | tr "a-z" "A-Z" | grep 102B > /dev/null
	#if [ $? -eq 0 ]; then
	#	sync;sync;reboot;reboot
	#fi
}

#-----------------
# Start from here
#-----------------

#################################
# Check if user has root access..
#################################
IsRoot

##########
# Getting license key if there is a OEM file
##########
if [ -e /etc/userful/oem -a ! -e /etc/X11/1Box.info ]; then
	echo
	echo "Getting OEM license key...."

        if [ -f /usr/share/umx-utils/install-license.sh ]; then
            /usr/share/umx-utils/install-license.sh > /var/log/oem.log 2>&1
        elif [ -f /usr/share/1box-utils/install-license.sh ]; then
            /usr/share/1box-utils/install-license.sh > /var/log/oem.log 2>&1
        fi

	if [ ! -e /etc/X11/1Box.info ]; then
		echo
		echo "Error: Unable to get OEM license key."
		cat /var/log/oem.log
		sleep 3
	else
		echo
		echo "Successfully obtained OEM license key."
		sleep 3
	fi
fi

#####
## Source dm.conf to find VIDEO_CONF
#####
if [ -f /etc/userful/dm.conf ]; then
    sed -e "s/^\[/#\[/g" /etc/userful/dm.conf > /tmp/dm.conf.tmp
    source /tmp/dm.conf.tmp
fi

#######
## Check the version of Multi-X server
##  - Can use /opt/MX11R7/lib/libpciaccess.so to check the current version of Multi-X.
#######
if [ -f /etc/X11/userful.Mxorg.conf ] && [ -f /opt/MX11R7/lib/libpciaccess.so ]; then
    # New version of Multi-X server.  
    
    # Check userful.Mxorg.conf. RgbPath cause X crash with the newer version of X server
    if grep -q "RgbPath" /etc/X11/userful.Mxorg.conf ; then
        rm -f /etc/X11/userful.Mxorg.conf
    fi
fi

############
## Set MXVER, X_CONFIGURE, XSERVER
############
source /etc/userful/os-info
# TODO:
#  - There must be a better way to set the version of Multi-X

if [ -f /opt/MX11R7/bin/Xorg ]; then
    if [ "$OSNAME" == "fedora" -a "$OSVER" == "2" -o \
	    "$OSNAME" == "fedora" -a "$OSVER" == "3" -o \
	    "$OSNAME" == "fedora" -a "$OSVER" == "4" -o \
	    "$OSNAME" == "novell" -a "$OSVER" == "9" -o \
	    "$OSNAME" == "suse" -a "$OSVER" == "9.1" -o \
	    "$OSNAME" == "suse" -a "$OSVER" == "9.3" -o \
	    "$OSNAME" == "centos" -a "$OSVER" == "4" -o \
	    "$OSNAME" == "freedows" -a "$OSVER" == "2005" -o \
	    "$OSNAME" == "ubuntu" -a "$OSVER" == "5.04" -o \
	    "$OSNAME" == "ubuntu" -a "$OSVER" == "5.10" -o \
	    "$OSNAME" == "xandros" -a "$OSVER" == "3.0" -o \
	    "$OSNAME" == "xandros" -a "$OSVER" == "4.0" -o \
	    "$OSNAME" == "morphix" -a "$OSVER" == "0.5-pre5" -o \
	    "$OSNAME" == "freespire" -a "$OSVER" == "1.0.4" -o \
	    "$OSNAME" == "debian" -a "$OSVER" == "3.1" ]; then
        # Use Old Multi-X for older distors
	    echo "MXVER=MX11R6" > /etc/userful/MXVERSION
        MXVER=MX11R6
        X_CONFIGURE="single"

    elif [ "$OSNAME" == "novell" ] || [ "$OSNAME" == "suse" ]; then
        # Use normal X server to generate xorg.conf.new
	    echo "MXVER=MX11R7" > /etc/userful/MXVERSION
        MXVER=MX11R7
        X_CONFIGURE="single"

    #elif [ "$OSNAME" == "ubuntu" -a "$OSVER" == "8.10" ]; then
    #	    echo "MXVER=MX11R7" > /etc/userful/MXVERSION
    #    MXVER=MX11R7
    #    X_CONFIGURE="single"

    else
	    echo "MXVER=MX11R7" > /etc/userful/MXVERSION
        MXVER=MX11R7
        X_CONFIGURE="multi"
    fi
else
	echo "MXVER=MX11R6" > /etc/userful/MXVERSION
    MXVER=MX11R6
fi

##
## Newer ATI cards require the newer X server to configure.
##  HD2400, 3100, 3200 and 3250
if lspci -n | grep -q "1002:94c3" || \
   lspci -n | grep -q "1002:9610" || \
   lspci -n | grep -q "1002:9611" || \
   lspci -n | grep -q "1002:95c5" ; then
    X_CONFIGURE="multi"
fi

##
## TODO:
##  - Don't reset video with "X -configure" on certain cases
##  - Some older distros have the device initialization problem with multiple VGA cards.
if [ "$OSNAME" == "ubuntu" ]; then
    if [ "$OSVER" == "8.10" ] || [ "$OSVER" == "9.04" ]; then
        VIDEO_RESET=disable
    fi
fi

if [ -x /usr/X11R6/bin/XFree86 ]; then
	XSERVER="/usr/X11R6/bin/XFree86"
elif [ -x /usr/X11R6/bin/Xorg ]; then
	XSERVER="/usr/X11R6/bin/Xorg"
elif [ -x /usr/bin/Xorg ]; then # For X 7.0
	XSERVER="/usr/bin/Xorg"
else
	XSERVER=X
fi


####################################
## Generate userful.Mxorg.conf if:
##  - It doesn't exist.
##  - There are any changes in graphic hardware
## Use old config file if VIDEO_CONF is static.
## Reset video card if VIDEO_RESET is enabled.
###############################################
if [ "$VIDEO_CONF" == "static" ]; then
    ## Static Configuration
    if [ ! -e /etc/X11/userful.Mxorg.conf ]; then
        if [ -e /etc/userful/DM-install ]; then
            configure_mx -f
        else
            configure_mx -n
        fi
    else
        if [ ! -e /etc/userful/X-fail ] && [ "$VIDEO_RESET" == "enable" ]; then

            echo "(II)VIDEO_RESET is enabled." >> $logfile
        	if [ "$X_CONFIGURE" == "multi" ]; then
            	/opt/$MXVER/bin/Xorg -configure -logfile /var/log/mx11r7-configure.log
        	else
		    	$XSERVER -configure > /dev/null 2>&1
        	fi
        fi
    fi

else
    ## Dynamic Configuration
    if [ ! -e /etc/X11/userful.Mxorg.conf ]; then
        if [ -e /etc/userful/DM-install ]; then
            configure_mx -f  # Generate userful.Mxorg.conf
        else
            configure_mx -n  # Generate userful.Mxorg.conf
        fi
    else
        if [ ! -e /etc/X11/vgainfo -o  ! -e /etc/stations -o \
               ! -e /etc/X11/stations -o ! -e /etc/mvgainfo ]; then
            configure_mx -n  # Generate userful.Mxorg.conf
        else
            $LSPCI -n | grep "0300: " > /etc/X11/vgainfo.new

            diff /etc/X11/vgainfo /etc/X11/vgainfo.new > /dev/null
            if [ $? != 0 ];then
                # there are changes in the graphic cards
                cp -f /etc/X11/userful.Mxorg.conf /etc/X11/userful.Mxorg.conf.old
                configure_mx -r  # Generate userful.Mxorg.conf
            else
                if [ ! -e /etc/userful/X-fail ] && [ "$VIDEO_RESET" == "enable" ]; then
                    echo "(II)VIDEO_RESET is enabled." >> $logfile

        			if [ "$X_CONFIGURE" == "multi" ]; then
            			/opt/$MXVER/bin/Xorg -configure -logfile /var/log/mx11r7-configure.log
        			else
		    			$XSERVER -configure > /dev/null 2>&1
        			fi
                fi
            fi
        fi
    fi
fi

if [ -x /opt/userful/bin/dm-gen-info ]; then
    /opt/userful/bin/dm-gen-info -compare
else
    /opt/userful/bin/sno-comp
fi

RET=$?
if [ $RET != 0 ]; then
	# there is change in the # of station of the key file
	# no need to re-create config file
	rm -f /etc/X11/xdm/Xservers
	rm -f /etc/stations
    if [ -x /opt/userful/bin/dm-gen-info ]; then
        /opt/userful/bin/dm-gen-info -compare
    else
        /opt/userful/bin/sno-comp
    fi
fi

## Generate licese info file
if [ -x /opt/userful/bin/dm-gen-info ]; then
    /opt/userful/bin/dm-gen-info -licenseinfo
fi

##
## Check Mandatory Device
if [ -f /etc/userful/userful-license-info ]; then
    source /etc/userful/userful-license-info

    # Delete usbinput if:
    #  - There is the mandatory device info in license key, and
    #  - License has been updated.
    if [ x"$MANDATORY_DEV" != x ] && [ $RET != 0 ]; then
        rm -f /etc/usbinput
    fi
fi
