#!/bin/bash
#
#  umx-shutdown.sh
#
############################
ProgramName=`basename $0`

###############
# usage()
###############
function usage()
{
	echo ""
	echo "Usage: userful [shutdown|reboot]"
	echo ""
	exit 1
}

#---------------
# Start here
#---------------
source /opt/userful/bin/userful-bash-lib.sh

##
## Check root access
IsRoot

[[ -z $1 ]] && usage
COMMAND=$1
shift

##############################################
# Parse COMMAND part and execute real command
##############################################
case "$COMMAND" in
	"-h")
        /opt/userful/bin/vtlock -disable
        telinit 0
		;;

	"-r")
        /opt/userful/bin/vtlock -disable
        telinit 6
		;;

	*)
		echo -e "\nError: Invalid command name - $COMMAND\n"
		usage
		;;
esac
