#!/usr/bin/env python

# Copyright (c) 2002-2008 Userful Corporation. All rights reserved.
# http://www.userful.com/

# progress-dialog.py

# this simple program is used to dislay something while we contact our
# servers. It gives users the sense of security that something is
# being done about the task they requested to be done

# TODO: include animation

# possible TODO: add the ability to actually show progress (e.g. a bar
# or percent or soemthing) rather than a static window

# possible TODO: implement as a library to allow any application to
# have a progress dialog

import gtk
import os
import time
import sys
import signal

import gettext

#gtk.glade.bindtextdomain("userful-control-panel", "/usr/share/locale")
#gtk.glade.textdomain("userful-control-panel")

gettext.bindtextdomain('userful-control-panel')
gettext.textdomain('userful-control-panel')

#gettext.bind_textdomain_codeset("userful-control-panel", "UTF-8")
#gettext.bind_textdomain_codeset("userful-control-panel", "ISO-8859-1")

_ = gettext.gettext

def read_args():
   return_dict = {}
   for arg in sys.argv[1:]:
       try:
           (keyname, keyvalue)=arg.split('=',1)
       except:
           break
       keyvalue = keyvalue.strip()
       keyname = keyname.strip()
       return_dict[keyname]=keyvalue
   return return_dict

def on_event_box_button_press(dialog, button):
    gtk.main_quit()
def on_main_window_destroy(dialog):
    gtk.main_quit()

def main():
    
    main_label_text = _("Connecting...")

    arg_dict = read_args()
    if arg_dict.has_key("text") and arg_dict["text"] != "":
        main_label_text = arg_dict["text"]

    main_window = gtk.Window()
    main_window.set_title("Progress")
    logo_path = "/usr/share/umx-utils/userful-logo.svg"
    if os.access(logo_path, os.R_OK) == 1:
        main_window.set_icon_from_file(logo_path)

    main_window.set_position(gtk.WIN_POS_CENTER_ALWAYS)
    main_window.set_type_hint(gtk.gdk.WINDOW_TYPE_HINT_DIALOG)
    main_window.set_border_width(10)

    event_box = gtk.EventBox()
    main_window.add(event_box)

    main_hbox = gtk.HBox(homogeneous=False, spacing=10)
    event_box.add(main_hbox)

    main_image = gtk.Image()
    # temporary:
    main_image.set_from_stock(gtk.STOCK_REDO, 1)
    # should eventually be something like:
    #main_image.set_from_file(filename)
    main_hbox.pack_start(main_image, expand=True, fill=True, padding=0)

    main_label = gtk.Label(str=main_label_text)
    main_hbox.pack_end(main_label, expand=True, fill=True, padding=0)

    #PyGlade_ins = PyGlade()

    #    PyGlade_ins.set_text(arg_dict["text"])
    event_box.connect("button_press_event", on_event_box_button_press)

    main_window.connect("destroy", on_main_window_destroy)
    main_window.show_all()

    #signal.signal(signal.SIGUSR1, PyGlade_ins.signal_handler)

    gtk.main()
    return

if __name__ == "__main__":
    main()
    sys.exit(0)
